/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.contrib.streaming.state.RocksDBMemoryConfiguration;
import org.apache.flink.contrib.streaming.state.RocksDBMemoryControllerUtils;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricMonitor;
import org.apache.flink.contrib.streaming.state.RocksDBSharedResources;
import org.apache.flink.contrib.streaming.state.RocksIteratorWrapper;
import org.apache.flink.contrib.streaming.state.ttl.RocksDbTtlCompactFiltersManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.LongFunctionWithException;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;

public class RocksDBOperationUtils {
    private static final String MANAGED_MEMORY_RESOURCE_ID = "state-rocks-managed-memory";
    private static final String FIXED_SLOT_MEMORY_RESOURCE_ID = "state-rocks-fixed-slot-memory";

    public static RocksDB openDB(String path, List<ColumnFamilyDescriptor> stateColumnFamilyDescriptors, List<ColumnFamilyHandle> stateColumnFamilyHandles, ColumnFamilyOptions columnFamilyOptions, DBOptions dbOptions) throws IOException {
        RocksDB dbRef;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>(1 + stateColumnFamilyDescriptors.size());
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions));
        columnFamilyDescriptors.addAll(stateColumnFamilyDescriptors);
        try {
            dbRef = RocksDB.open((DBOptions)((DBOptions)Preconditions.checkNotNull((Object)dbOptions)), (String)((String)Preconditions.checkNotNull((Object)path)), columnFamilyDescriptors, stateColumnFamilyHandles);
        }
        catch (RocksDBException e) {
            IOUtils.closeQuietly((AutoCloseable)columnFamilyOptions);
            columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
            throw new IOException("Error while opening RocksDB instance.", e);
        }
        Preconditions.checkState((1 + stateColumnFamilyDescriptors.size() == stateColumnFamilyHandles.size() ? 1 : 0) != 0, (Object)"Not all requested column family handles have been created");
        return dbRef;
    }

    public static RocksIteratorWrapper getRocksIterator(RocksDB db) {
        return new RocksIteratorWrapper(db.newIterator());
    }

    public static RocksIteratorWrapper getRocksIterator(RocksDB db, ColumnFamilyHandle columnFamilyHandle) {
        return new RocksIteratorWrapper(db.newIterator(columnFamilyHandle));
    }

    public static void registerKvStateInformation(Map<String, RocksDBKeyedStateBackend.RocksDbKvStateInfo> kvStateInformation, RocksDBNativeMetricMonitor nativeMetricMonitor, String columnFamilyName, RocksDBKeyedStateBackend.RocksDbKvStateInfo registeredColumn) {
        kvStateInformation.put(columnFamilyName, registeredColumn);
        if (nativeMetricMonitor != null) {
            nativeMetricMonitor.registerColumnFamily(columnFamilyName, registeredColumn.columnFamilyHandle);
        }
    }

    public static RocksDBKeyedStateBackend.RocksDbKvStateInfo createStateInfo(RegisteredStateMetaInfoBase metaInfoBase, RocksDB db, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, @Nullable RocksDbTtlCompactFiltersManager ttlCompactFiltersManager) {
        ColumnFamilyDescriptor columnFamilyDescriptor = RocksDBOperationUtils.createColumnFamilyDescriptor(metaInfoBase, columnFamilyOptionsFactory, ttlCompactFiltersManager);
        return new RocksDBKeyedStateBackend.RocksDbKvStateInfo(RocksDBOperationUtils.createColumnFamily(columnFamilyDescriptor, db), metaInfoBase);
    }

    public static ColumnFamilyDescriptor createColumnFamilyDescriptor(RegisteredStateMetaInfoBase metaInfoBase, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, @Nullable RocksDbTtlCompactFiltersManager ttlCompactFiltersManager) {
        byte[] nameBytes;
        ColumnFamilyOptions options = RocksDBOperationUtils.createColumnFamilyOptions(columnFamilyOptionsFactory, metaInfoBase.getName());
        if (ttlCompactFiltersManager != null) {
            ttlCompactFiltersManager.setAndRegisterCompactFilterIfStateTtl(metaInfoBase, options);
        }
        Preconditions.checkState((!Arrays.equals(RocksDB.DEFAULT_COLUMN_FAMILY, nameBytes = metaInfoBase.getName().getBytes(ConfigConstants.DEFAULT_CHARSET)) ? 1 : 0) != 0, (Object)"The chosen state name 'default' collides with the name of the default column family!");
        return new ColumnFamilyDescriptor(nameBytes, options);
    }

    public static ColumnFamilyOptions createColumnFamilyOptions(Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, String stateName) {
        return columnFamilyOptionsFactory.apply(stateName).setMergeOperatorName("stringappendtest");
    }

    private static ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnDescriptor, RocksDB db) {
        try {
            return db.createColumnFamily(columnDescriptor);
        }
        catch (RocksDBException e) {
            IOUtils.closeQuietly((AutoCloseable)columnDescriptor.getOptions());
            throw new FlinkRuntimeException("Error creating ColumnFamilyHandle.", (Throwable)e);
        }
    }

    public static void addColumnFamilyOptionsToCloseLater(List<ColumnFamilyOptions> columnFamilyOptions, ColumnFamilyHandle columnFamilyHandle) {
        try {
            if (columnFamilyHandle != null && columnFamilyHandle.getDescriptor() != null) {
                columnFamilyOptions.add(columnFamilyHandle.getDescriptor().getOptions());
            }
        }
        catch (RocksDBException rocksDBException) {
            // empty catch block
        }
    }

    @Nullable
    public static OpaqueMemoryResource<RocksDBSharedResources> allocateSharedCachesIfConfigured(RocksDBMemoryConfiguration memoryConfig, MemoryManager memoryManager, Logger logger) throws IOException {
        if (!memoryConfig.isUsingFixedMemoryPerSlot() && !memoryConfig.isUsingManagedMemory()) {
            return null;
        }
        double highPriorityPoolRatio = memoryConfig.getHighPriorityPoolRatio();
        double writeBufferRatio = memoryConfig.getWriteBufferRatio();
        LongFunctionWithException allocator = size -> RocksDBMemoryControllerUtils.allocateRocksDBSharedResources(size, writeBufferRatio, highPriorityPoolRatio);
        try {
            if (memoryConfig.isUsingFixedMemoryPerSlot()) {
                assert (memoryConfig.getFixedMemoryPerSlot() != null);
                logger.info("Getting fixed-size shared cache for RocksDB.");
                return memoryManager.getExternalSharedMemoryResource(FIXED_SLOT_MEMORY_RESOURCE_ID, allocator, memoryConfig.getFixedMemoryPerSlot().getBytes());
            }
            logger.info("Getting managed memory shared cache for RocksDB.");
            return memoryManager.getSharedMemoryResourceForManagedMemory(MANAGED_MEMORY_RESOURCE_ID, allocator);
        }
        catch (Exception e) {
            throw new IOException("Failed to acquire shared cache resource for RocksDB", e);
        }
    }
}

