/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBKeySerializationUtils;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.FlinkRuntimeException;

@NotThreadSafe
@Internal
class RocksDBSerializedCompositeKeyBuilder<K> {
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final DataOutputSerializer keyOutView;
    @Nonnegative
    private final int keyGroupPrefixBytes;
    private final boolean keySerializerTypeVariableSized;
    @Nonnegative
    private int afterKeyMark;

    public RocksDBSerializedCompositeKeyBuilder(@Nonnull TypeSerializer<K> keySerializer, @Nonnegative int keyGroupPrefixBytes, @Nonnegative int initialSize) {
        this(keySerializer, new DataOutputSerializer(initialSize), keyGroupPrefixBytes, RocksDBKeySerializationUtils.isSerializerTypeVariableSized(keySerializer), 0);
    }

    @VisibleForTesting
    RocksDBSerializedCompositeKeyBuilder(@Nonnull TypeSerializer<K> keySerializer, @Nonnull DataOutputSerializer keyOutView, @Nonnegative int keyGroupPrefixBytes, boolean keySerializerTypeVariableSized, @Nonnegative int afterKeyMark) {
        this.keySerializer = keySerializer;
        this.keyOutView = keyOutView;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.keySerializerTypeVariableSized = keySerializerTypeVariableSized;
        this.afterKeyMark = afterKeyMark;
    }

    public void setKeyAndKeyGroup(@Nonnull K key, @Nonnegative int keyGroupId) {
        try {
            this.serializeKeyGroupAndKey(key, keyGroupId);
        }
        catch (IOException shouldNeverHappen) {
            throw new FlinkRuntimeException((Throwable)shouldNeverHappen);
        }
    }

    @Nonnull
    public <N> byte[] buildCompositeKeyNamespace(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer) {
        try {
            this.serializeNamespace(namespace, namespaceSerializer);
            byte[] result = this.keyOutView.getCopyOfBuffer();
            this.resetToKey();
            return result;
        }
        catch (IOException shouldNeverHappen) {
            throw new FlinkRuntimeException((Throwable)shouldNeverHappen);
        }
    }

    @Nonnull
    public <N, UK> byte[] buildCompositeKeyNamesSpaceUserKey(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull UK userKey, @Nonnull TypeSerializer<UK> userKeySerializer) throws IOException {
        this.serializeNamespace(namespace, namespaceSerializer);
        userKeySerializer.serialize(userKey, (DataOutputView)this.keyOutView);
        byte[] result = this.keyOutView.getCopyOfBuffer();
        this.resetToKey();
        return result;
    }

    private void serializeKeyGroupAndKey(K key, int keyGroupId) throws IOException {
        this.resetFully();
        RocksDBKeySerializationUtils.writeKeyGroup(keyGroupId, this.keyGroupPrefixBytes, (DataOutputView)this.keyOutView);
        this.keySerializer.serialize(key, (DataOutputView)this.keyOutView);
        this.afterKeyMark = this.keyOutView.length();
    }

    private <N> void serializeNamespace(@Nonnull N namespace, @Nonnull TypeSerializer<N> namespaceSerializer) throws IOException {
        assert (this.isKeyWritten());
        boolean ambiguousCompositeKeyPossible = this.isAmbiguousCompositeKeyPossible(namespaceSerializer);
        if (ambiguousCompositeKeyPossible) {
            RocksDBKeySerializationUtils.writeVariableIntBytes(this.afterKeyMark - this.keyGroupPrefixBytes, (DataOutputView)this.keyOutView);
        }
        RocksDBKeySerializationUtils.writeNameSpace(namespace, namespaceSerializer, this.keyOutView, ambiguousCompositeKeyPossible);
    }

    private void resetFully() {
        this.afterKeyMark = 0;
        this.keyOutView.clear();
    }

    private void resetToKey() {
        this.keyOutView.setPosition(this.afterKeyMark);
    }

    private boolean isKeyWritten() {
        return this.afterKeyMark > 0;
    }

    @VisibleForTesting
    boolean isAmbiguousCompositeKeyPossible(TypeSerializer<?> namespaceSerializer) {
        return this.keySerializerTypeVariableSized & RocksDBKeySerializationUtils.isSerializerTypeVariableSized(namespaceSerializer);
    }
}

