/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.iterator;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.RocksDBKeySerializationUtils;
import org.apache.flink.contrib.streaming.state.RocksIteratorWrapper;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.util.FlinkRuntimeException;

public class RocksStateKeysIterator<K>
implements Iterator<K>,
AutoCloseable {
    @Nonnull
    private final RocksIteratorWrapper iterator;
    @Nonnull
    private final String state;
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final byte[] namespaceBytes;
    private final boolean ambiguousKeyPossible;
    private final int keyGroupPrefixBytes;
    private final DataInputDeserializer byteArrayDataInputView;
    private K nextKey;
    private K previousKey;

    public RocksStateKeysIterator(@Nonnull RocksIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible, @Nonnull byte[] namespaceBytes) {
        this.iterator = iterator;
        this.state = state;
        this.keySerializer = keySerializer;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.namespaceBytes = namespaceBytes;
        this.nextKey = null;
        this.previousKey = null;
        this.ambiguousKeyPossible = ambiguousKeyPossible;
        this.byteArrayDataInputView = new DataInputDeserializer();
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKey == null && this.iterator.isValid()) {
                byte[] keyBytes = this.iterator.key();
                K currentKey = this.deserializeKey(keyBytes, this.byteArrayDataInputView);
                int namespaceByteStartPos = this.byteArrayDataInputView.getPosition();
                if (this.isMatchingNameSpace(keyBytes, namespaceByteStartPos) && !Objects.equals(this.previousKey, currentKey)) {
                    this.previousKey = currentKey;
                    this.nextKey = currentKey;
                }
                this.iterator.next();
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access state [" + this.state + "]", (Throwable)e);
        }
        return this.nextKey != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access state [" + this.state + "]");
        }
        K tmpKey = this.nextKey;
        this.nextKey = null;
        return tmpKey;
    }

    private K deserializeKey(byte[] keyBytes, DataInputDeserializer readView) throws IOException {
        readView.setBuffer(keyBytes, this.keyGroupPrefixBytes, keyBytes.length - this.keyGroupPrefixBytes);
        return RocksDBKeySerializationUtils.readKey(this.keySerializer, this.byteArrayDataInputView, this.ambiguousKeyPossible);
    }

    private boolean isMatchingNameSpace(@Nonnull byte[] key, int beginPos) {
        int namespaceBytesLength = this.namespaceBytes.length;
        int basicLength = namespaceBytesLength + beginPos;
        if (key.length >= basicLength) {
            for (int i = 0; i < namespaceBytesLength; ++i) {
                if (key[beginPos + i] == this.namespaceBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

