/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.TimerSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimerSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<TimerHeapInternalTimer<String, Integer>, TimerHeapInternalTimer<String, Integer>> {
    public TimerSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<TimerHeapInternalTimer<String, Integer>, TimerHeapInternalTimer<String, Integer>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("timer-serializer", flinkVersion, TimerSerializerSetup.class, TimerSerializerVerifier.class));
        }
        return testSpecifications;
    }

    private static TypeSerializer<TimerHeapInternalTimer<String, Integer>> stringIntTimerSerializerSupplier() {
        return new TimerSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
    }

    public static final class TimerSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TimerHeapInternalTimer<String, Integer>> {
        public TypeSerializer<TimerHeapInternalTimer<String, Integer>> createUpgradedSerializer() {
            return new TimerSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        public Matcher<TimerHeapInternalTimer<String, Integer>> testDataMatcher() {
            return Matchers.is((Object)new TimerHeapInternalTimer(12345L, (Object)"key", (Object)678));
        }

        public Matcher<TypeSerializerSchemaCompatibility<TimerHeapInternalTimer<String, Integer>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class TimerSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TimerHeapInternalTimer<String, Integer>> {
        public TypeSerializer<TimerHeapInternalTimer<String, Integer>> createPriorSerializer() {
            return new TimerSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        }

        public TimerHeapInternalTimer<String, Integer> createTestData() {
            return new TimerHeapInternalTimer(12345L, (Object)"key", (Object)678);
        }
    }
}

