/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.checkpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.junit.Assert;
import org.junit.Test;

public class ListCheckpointedTest {
    @Test
    public void testUDFReturningNull() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(null));
    }

    @Test
    public void testUDFReturningEmpty() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(Collections.emptyList()));
    }

    @Test
    public void testUDFReturningData() throws Exception {
        ListCheckpointedTest.testUDF(new TestUserFunction(Arrays.asList(1, 2, 3)));
    }

    private static void testUDF(TestUserFunction userFunction) throws Exception {
        OperatorSubtaskState snapshot;
        try (AbstractStreamOperatorTestHarness<Integer> testHarness = ListCheckpointedTest.createTestHarness(userFunction);){
            testHarness.open();
            snapshot = testHarness.snapshot(0L, 0L);
            Assert.assertFalse((boolean)userFunction.isRestored());
        }
        testHarness = ListCheckpointedTest.createTestHarness(userFunction);
        var3_2 = null;
        try {
            testHarness.initializeState(snapshot);
            testHarness.open();
            Assert.assertTrue((boolean)userFunction.isRestored());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (testHarness != null) {
                if (var3_2 != null) {
                    try {
                        testHarness.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    testHarness.close();
                }
            }
        }
    }

    private static AbstractStreamOperatorTestHarness<Integer> createTestHarness(TestUserFunction userFunction) throws Exception {
        return new AbstractStreamOperatorTestHarness<Integer>((StreamOperator<Integer>)new StreamMap((MapFunction)userFunction), 1, 1, 0);
    }

    private static class TestUserFunction
    extends RichMapFunction<Integer, Integer>
    implements ListCheckpointed<Integer> {
        private static final long serialVersionUID = -8981369286399531925L;
        private final List<Integer> expected;
        private boolean restored;

        public TestUserFunction(List<Integer> expected) {
            this.expected = expected;
            this.restored = false;
        }

        public Integer map(Integer value) throws Exception {
            return value;
        }

        public List<Integer> snapshotState(long checkpointId, long timestamp) throws Exception {
            return this.expected;
        }

        public void restoreState(List<Integer> state) throws Exception {
            if (null != this.expected) {
                Assert.assertEquals(this.expected, state);
            } else {
                Assert.assertTrue((boolean)state.isEmpty());
            }
            this.restored = true;
        }

        public boolean isRestored() {
            return this.restored;
        }
    }
}

