/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendBuilder;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.util.BlockingFSDataInputStream;
import org.apache.flink.streaming.api.operators.BackendRestorerProcedure;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.FunctionWithException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class BackendRestorerProcedureTest
extends TestLogger {
    private final FunctionWithException<Collection<OperatorStateHandle>, OperatorStateBackend, Exception> backendSupplier = stateHandles -> new DefaultOperatorStateBackendBuilder(((Object)((Object)this)).getClass().getClassLoader(), new ExecutionConfig(), true, stateHandles, new CloseableRegistry()).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreProcedureOrderAndFailure() throws Exception {
        SnapshotResult snapshotResult;
        CloseableRegistry closeableRegistry = new CloseableRegistry();
        MemCheckpointStreamFactory checkpointStreamFactory = new MemCheckpointStreamFactory(1024);
        ListStateDescriptor stateDescriptor = new ListStateDescriptor("test-state", Integer.class);
        OperatorStateBackend originalBackend = (OperatorStateBackend)this.backendSupplier.apply(Collections.emptyList());
        try {
            ListState listState = originalBackend.getListState(stateDescriptor);
            listState.add((Object)0);
            listState.add((Object)1);
            listState.add((Object)2);
            listState.add((Object)3);
            RunnableFuture snapshot = originalBackend.snapshot(0L, 0L, (CheckpointStreamFactory)checkpointStreamFactory, CheckpointOptions.forCheckpointWithDefaultLocation());
            snapshot.run();
            snapshotResult = (SnapshotResult)snapshot.get();
        }
        finally {
            originalBackend.close();
            originalBackend.dispose();
        }
        OperatorStateHandle firstFailHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        OperatorStateHandle secondSuccessHandle = (OperatorStateHandle)PowerMockito.spy((Object)snapshotResult.getJobManagerOwnedSnapshot());
        OperatorStateHandle thirdNotUsedHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        List<StateObjectCollection> sortedRestoreOptions = Arrays.asList(new StateObjectCollection(Collections.singletonList(firstFailHandle)), new StateObjectCollection(Collections.singletonList(secondSuccessHandle)), new StateObjectCollection(Collections.singletonList(thirdNotUsedHandle)));
        BackendRestorerProcedure restorerProcedure = new BackendRestorerProcedure(this.backendSupplier, closeableRegistry, "test op state backend");
        OperatorStateBackend restoredBackend = (OperatorStateBackend)restorerProcedure.createAndRestore(sortedRestoreOptions);
        Assert.assertNotNull((Object)restoredBackend);
        try {
            ((OperatorStateHandle)Mockito.verify((Object)firstFailHandle)).openInputStream();
            ((OperatorStateHandle)Mockito.verify((Object)secondSuccessHandle)).openInputStream();
            PowerMockito.verifyZeroInteractions((Object[])new Object[]{thirdNotUsedHandle});
            ListState listState = restoredBackend.getListState(stateDescriptor);
            Iterator stateIterator = ((Iterable)listState.get()).iterator();
            Assert.assertEquals((long)0L, (long)((Integer)stateIterator.next()).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)stateIterator.next()).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)stateIterator.next()).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)stateIterator.next()).intValue());
            Assert.assertFalse((boolean)stateIterator.hasNext());
        }
        finally {
            restoredBackend.close();
            restoredBackend.dispose();
        }
    }

    @Test
    public void testExceptionThrownIfAllRestoresFailed() throws Exception {
        CloseableRegistry closeableRegistry = new CloseableRegistry();
        OperatorStateHandle firstFailHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        OperatorStateHandle secondFailHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        OperatorStateHandle thirdFailHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        List<StateObjectCollection> sortedRestoreOptions = Arrays.asList(new StateObjectCollection(Collections.singletonList(firstFailHandle)), new StateObjectCollection(Collections.singletonList(secondFailHandle)), new StateObjectCollection(Collections.singletonList(thirdFailHandle)));
        BackendRestorerProcedure restorerProcedure = new BackendRestorerProcedure(this.backendSupplier, closeableRegistry, "test op state backend");
        try {
            restorerProcedure.createAndRestore(sortedRestoreOptions);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((OperatorStateHandle)Mockito.verify((Object)firstFailHandle)).openInputStream();
        ((OperatorStateHandle)Mockito.verify((Object)secondFailHandle)).openInputStream();
        ((OperatorStateHandle)Mockito.verify((Object)thirdFailHandle)).openInputStream();
    }

    @Test
    public void testCanBeCanceledViaRegistry() throws Exception {
        CloseableRegistry closeableRegistry = new CloseableRegistry();
        OneShotLatch waitForBlock = new OneShotLatch();
        OneShotLatch unblock = new OneShotLatch();
        OperatorStateHandle blockingRestoreHandle = (OperatorStateHandle)PowerMockito.mock(OperatorStateHandle.class);
        PowerMockito.when((Object)blockingRestoreHandle.openInputStream()).thenReturn((Object)new BlockingFSDataInputStream(waitForBlock, unblock));
        List<StateObjectCollection> sortedRestoreOptions = Collections.singletonList(new StateObjectCollection(Collections.singletonList(blockingRestoreHandle)));
        BackendRestorerProcedure restorerProcedure = new BackendRestorerProcedure(this.backendSupplier, closeableRegistry, "test op state backend");
        AtomicReference<Object> exceptionReference = new AtomicReference<Object>(null);
        Thread restoreThread = new Thread(() -> {
            try {
                restorerProcedure.createAndRestore(sortedRestoreOptions);
            }
            catch (Exception e) {
                exceptionReference.set(e);
            }
        });
        restoreThread.start();
        waitForBlock.await();
        closeableRegistry.close();
        unblock.trigger();
        restoreThread.join();
        Exception exception = exceptionReference.get();
        Assert.assertTrue((boolean)(exception instanceof FlinkException));
    }
}

