/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.time.Duration;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierAlignmentUtil;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorImpl;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxProcessor;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailboxImpl;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class BarrierAlignmentUtilTest {
    @Test
    public void testDelayableTimerNotHiddenException() throws Exception {
        TaskMailboxImpl mailbox = new TaskMailboxImpl();
        MailboxProcessor mailboxProcessor = new MailboxProcessor(controller -> {}, (TaskMailbox)mailbox, StreamTaskActionExecutor.IMMEDIATE);
        MailboxExecutorImpl mailboxExecutor = new MailboxExecutorImpl((TaskMailbox)mailbox, 0, StreamTaskActionExecutor.IMMEDIATE, mailboxProcessor);
        TestProcessingTimeService timerService = new TestProcessingTimeService();
        timerService.setCurrentTime(System.currentTimeMillis());
        BarrierAlignmentUtil.DelayableTimer delayableTimer = BarrierAlignmentUtil.createRegisterTimerCallback((MailboxExecutor)mailboxExecutor, (TimerService)timerService);
        Duration delay = Duration.ofMinutes(10L);
        delayableTimer.registerTask(() -> {
            throw new ExpectedTestException();
        }, delay);
        timerService.advance(delay.toMillis());
        Throwable t = Assert.assertThrows((String)"BarrierAlignmentUtil.DelayableTimer should not hidden exception", Exception.class, () -> mailboxProcessor.runMailboxStep());
        ExceptionUtils.assertThrowable((Throwable)t, ExpectedTestException.class);
    }
}

