/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.util.TwoInputStreamOperatorTestHarness;

public class KeyedTwoInputStreamOperatorTestHarness<K, IN1, IN2, OUT>
extends TwoInputStreamOperatorTestHarness<IN1, IN2, OUT> {
    public KeyedTwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator, KeySelector<IN1, K> keySelector1, KeySelector<IN2, K> keySelector2, TypeInformation<K> keyType, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operator, maxParallelism, numSubtasks, subtaskIndex);
        ClosureCleaner.clean(keySelector1, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        ClosureCleaner.clean(keySelector2, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(0, keySelector1);
        this.config.setStatePartitioner(1, keySelector2);
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig));
        this.config.serializeAllConfigs();
    }

    public KeyedTwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator, KeySelector<IN1, K> keySelector1, KeySelector<IN2, K> keySelector2, TypeInformation<K> keyType) throws Exception {
        this(operator, keySelector1, keySelector2, keyType, 1, 1, 0);
    }

    public int numKeyedStateEntries() {
        AbstractStreamOperator abstractStreamOperator = (AbstractStreamOperator)this.operator;
        KeyedStateBackend keyedStateBackend = abstractStreamOperator.getKeyedStateBackend();
        if (keyedStateBackend instanceof HeapKeyedStateBackend) {
            return ((HeapKeyedStateBackend)keyedStateBackend).numKeyValueStateEntries();
        }
        throw new UnsupportedOperationException();
    }
}

