/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.async.queue.QueueUtil;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.UnorderedStreamElementQueue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class UnorderedStreamElementQueueTest
extends TestLogger {
    @Test
    public void testCompletionOrder() {
        UnorderedStreamElementQueue queue = new UnorderedStreamElementQueue(8);
        ResultFuture<Integer> record1 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)1, 0L));
        ResultFuture<Integer> record2 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)2, 1L));
        QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new Watermark(2L));
        ResultFuture<Integer> record3 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)3, 3L));
        ResultFuture<Integer> record4 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)4, 4L));
        QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new Watermark(5L));
        ResultFuture<Integer> record5 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)5, 6L));
        ResultFuture<Integer> record6 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)6, 7L));
        Assert.assertEquals(Collections.emptyList(), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)8L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        record3.complete(Arrays.asList(13));
        Assert.assertEquals(Collections.emptyList(), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)8L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        record2.complete(Arrays.asList(12));
        Assert.assertEquals(Arrays.asList(new StreamRecord((Object)12, 1L)), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)7L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        record6.complete(Arrays.asList(16));
        record4.complete(Arrays.asList(14));
        Assert.assertEquals(Collections.emptyList(), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)7L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        record1.complete(Arrays.asList(11));
        Assert.assertEquals(Arrays.asList(new StreamRecord((Object)11, 0L), new Watermark(2L), new StreamRecord((Object)13, 3L), new StreamRecord((Object)14, 4L), new Watermark(5L), new StreamRecord((Object)16, 7L)), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)1L, (long)queue.size());
        Assert.assertFalse((boolean)queue.isEmpty());
        record5.complete(Arrays.asList(15));
        Assert.assertEquals(Arrays.asList(new StreamRecord((Object)15, 6L)), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
        Assert.assertEquals((long)0L, (long)queue.size());
        Assert.assertTrue((boolean)queue.isEmpty());
        Assert.assertEquals(Collections.emptyList(), QueueUtil.popCompleted((StreamElementQueue<Integer>)queue));
    }
}

