/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.NonChainedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.util.Preconditions;

public class StreamConfigChainer<OWNER> {
    public static final int MAIN_NODE_ID = 0;
    private final OWNER owner;
    private final StreamConfig headConfig;
    private final Map<Integer, StreamConfig> chainedConfigs = new HashMap<Integer, StreamConfig>();
    private final int numberOfNonChainedOutputs;
    private int bufferTimeout;
    private StreamConfig tailConfig;
    private int chainIndex = 0;

    StreamConfigChainer(OperatorID headOperatorID, StreamConfig headConfig, OWNER owner, int numberOfNonChainedOutputs) {
        this.owner = Preconditions.checkNotNull(owner);
        this.headConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.tailConfig = (StreamConfig)Preconditions.checkNotNull((Object)headConfig);
        this.numberOfNonChainedOutputs = numberOfNonChainedOutputs;
        this.head(headOperatorID);
    }

    private void head(OperatorID headOperatorID) {
        this.headConfig.setOperatorID(headOperatorID);
        this.headConfig.setChainStart();
        this.headConfig.setChainIndex(this.chainIndex);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer, boolean createKeyedStateBackend) {
        return this.chain(operatorID, operator, typeSerializer, typeSerializer, createKeyedStateBackend);
    }

    public <T> StreamConfigChainer<OWNER> chain(OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer) {
        return this.chain(new OperatorID(), operator, typeSerializer);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<T, T> operator, TypeSerializer<T> typeSerializer) {
        return this.chain(operatorID, operator, typeSerializer, typeSerializer, false);
    }

    public <T> StreamConfigChainer<OWNER> chain(OneInputStreamOperatorFactory<T, T> operatorFactory, TypeSerializer<T> typeSerializer) {
        return this.chain(new OperatorID(), operatorFactory, typeSerializer);
    }

    public <T> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperatorFactory<T, T> operatorFactory, TypeSerializer<T> typeSerializer) {
        return this.chain(operatorID, (StreamOperatorFactory)operatorFactory, (TypeSerializer)typeSerializer, (TypeSerializer)typeSerializer, false);
    }

    private <IN, OUT> StreamConfigChainer<OWNER> chain(OperatorID operatorID, OneInputStreamOperator<IN, OUT> operator, TypeSerializer<IN> inputSerializer, TypeSerializer<OUT> outputSerializer, boolean createKeyedStateBackend) {
        return this.chain(operatorID, (StreamOperatorFactory<OUT>)SimpleOperatorFactory.of(operator), inputSerializer, outputSerializer, createKeyedStateBackend);
    }

    public <IN, OUT> StreamConfigChainer<OWNER> chain(OperatorID operatorID, StreamOperatorFactory<OUT> operatorFactory, TypeSerializer<IN> inputSerializer, TypeSerializer<OUT> outputSerializer, boolean createKeyedStateBackend) {
        ++this.chainIndex;
        StreamEdge streamEdge = new StreamEdge(new StreamNode(Integer.valueOf(this.tailConfig.getChainIndex()), null, null, (StreamOperator)null, null, null), new StreamNode(Integer.valueOf(this.chainIndex), null, null, (StreamOperator)null, null, null), 0, null, null);
        streamEdge.setBufferTimeout((long)this.bufferTimeout);
        this.tailConfig.setChainedOutputs(Collections.singletonList(streamEdge));
        this.tailConfig = new StreamConfig(new Configuration());
        this.tailConfig.setStreamOperatorFactory((StreamOperatorFactory)Preconditions.checkNotNull(operatorFactory));
        this.tailConfig.setOperatorID((OperatorID)Preconditions.checkNotNull((Object)operatorID));
        this.tailConfig.setupNetworkInputs(new TypeSerializer[]{inputSerializer});
        this.tailConfig.setTypeSerializerOut(outputSerializer);
        if (createKeyedStateBackend) {
            this.tailConfig.setStateKeySerializer(inputSerializer);
            this.tailConfig.setStateBackendUsesManagedMemory(true);
            this.tailConfig.setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.STATE_BACKEND, 1.0);
        }
        this.tailConfig.setChainIndex(this.chainIndex);
        this.tailConfig.serializeAllConfigs();
        this.chainedConfigs.put(this.chainIndex, this.tailConfig);
        return this;
    }

    public OWNER finish() {
        Preconditions.checkState((this.chainIndex > 0 ? 1 : 0) != 0, (Object)"Use finishForSingletonOperatorChain");
        LinkedList<NonChainedOutput> outEdgesInOrder = new LinkedList<NonChainedOutput>();
        StreamNode sourceVertex = new StreamNode(Integer.valueOf(this.chainIndex), null, null, (StreamOperator)null, null, null);
        for (int i = 0; i < this.numberOfNonChainedOutputs; ++i) {
            NonChainedOutput streamOutput = new NonChainedOutput(true, sourceVertex.getId(), 1, 1, 100L, false, new IntermediateDataSetID(), null, (StreamPartitioner)new BroadcastPartitioner(), ResultPartitionType.PIPELINED_BOUNDED);
            outEdgesInOrder.add(streamOutput);
        }
        this.tailConfig.setChainEnd();
        this.tailConfig.setNumberOfOutputs(this.numberOfNonChainedOutputs);
        this.tailConfig.setVertexNonChainedOutputs(outEdgesInOrder);
        this.tailConfig.setOperatorNonChainedOutputs(outEdgesInOrder);
        this.chainedConfigs.values().forEach(StreamConfig::serializeAllConfigs);
        this.headConfig.setAndSerializeTransitiveChainedTaskConfigs(this.chainedConfigs);
        this.headConfig.setVertexNonChainedOutputs(outEdgesInOrder);
        this.headConfig.serializeAllConfigs();
        return this.owner;
    }

    public <OUT> OWNER finishForSingletonOperatorChain(TypeSerializer<OUT> outputSerializer) {
        return this.finishForSingletonOperatorChain(outputSerializer, (StreamPartitioner<?>)new BroadcastPartitioner());
    }

    public <OUT> OWNER finishForSingletonOperatorChain(TypeSerializer<OUT> outputSerializer, StreamPartitioner<?> partitioner) {
        Preconditions.checkState((this.chainIndex == 0 ? 1 : 0) != 0, (Object)"Use finishForSingletonOperatorChain");
        Preconditions.checkState((this.headConfig == this.tailConfig ? 1 : 0) != 0);
        AbstractStreamOperator dummyOperator = new AbstractStreamOperator<OUT>(){
            private static final long serialVersionUID = 1L;
        };
        LinkedList<NonChainedOutput> streamOutputs = new LinkedList<NonChainedOutput>();
        StreamNode sourceVertexDummy = new StreamNode(Integer.valueOf(0), "group", null, (StreamOperator)dummyOperator, "source dummy", SourceStreamTask.class);
        for (int i = 0; i < this.numberOfNonChainedOutputs; ++i) {
            streamOutputs.add(new NonChainedOutput(true, sourceVertexDummy.getId(), 1, 1, 100L, false, new IntermediateDataSetID(), null, partitioner, ResultPartitionType.PIPELINED_BOUNDED));
        }
        this.headConfig.setVertexID(Integer.valueOf(0));
        this.headConfig.setNumberOfOutputs(1);
        this.headConfig.setVertexNonChainedOutputs(streamOutputs);
        this.headConfig.setOperatorNonChainedOutputs(streamOutputs);
        this.chainedConfigs.values().forEach(StreamConfig::serializeAllConfigs);
        this.headConfig.setAndSerializeTransitiveChainedTaskConfigs(this.chainedConfigs);
        this.headConfig.setVertexNonChainedOutputs(streamOutputs);
        this.headConfig.setTypeSerializerOut(outputSerializer);
        this.headConfig.serializeAllConfigs();
        return this.owner;
    }

    public StreamConfigChainer<OWNER> name(String name) {
        this.tailConfig.setOperatorName(name);
        return this;
    }

    public void setBufferTimeout(int bufferTimeout) {
        this.bufferTimeout = bufferTimeout;
    }
}

