/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;

@Internal
public final class StreamElementSerializer<T>
extends TypeSerializer<StreamElement> {
    private static final long serialVersionUID = 1L;
    private static final int TAG_REC_WITH_TIMESTAMP = 0;
    private static final int TAG_REC_WITHOUT_TIMESTAMP = 1;
    private static final int TAG_WATERMARK = 2;
    private static final int TAG_LATENCY_MARKER = 3;
    private static final int TAG_STREAM_STATUS = 4;
    private final TypeSerializer<T> typeSerializer;

    public StreamElementSerializer(TypeSerializer<T> serializer) {
        if (serializer instanceof StreamElementSerializer) {
            throw new RuntimeException("StreamRecordSerializer given to StreamRecordSerializer as value TypeSerializer: " + serializer);
        }
        this.typeSerializer = Objects.requireNonNull(serializer);
    }

    public TypeSerializer<T> getContainedTypeSerializer() {
        return this.typeSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public StreamElementSerializer<T> duplicate() {
        TypeSerializer copy = this.typeSerializer.duplicate();
        return copy == this.typeSerializer ? this : new StreamElementSerializer<T>(copy);
    }

    public StreamRecord<T> createInstance() {
        return new StreamRecord<Object>(this.typeSerializer.createInstance());
    }

    public int getLength() {
        return -1;
    }

    public StreamElement copy(StreamElement from) {
        if (from.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            return fromRecord.copy(this.typeSerializer.copy(fromRecord.getValue()));
        }
        if (from.isWatermark() || from.isWatermarkStatus() || from.isLatencyMarker()) {
            return from;
        }
        throw new RuntimeException();
    }

    public StreamElement copy(StreamElement from, StreamElement reuse) {
        if (from.isRecord() && reuse.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            StreamRecord reuseRecord = reuse.asRecord();
            Object valueCopy = this.typeSerializer.copy(fromRecord.getValue(), reuseRecord.getValue());
            fromRecord.copyTo(valueCopy, reuseRecord);
            return reuse;
        }
        if (from.isWatermark() || from.isWatermarkStatus() || from.isLatencyMarker()) {
            return from;
        }
        throw new RuntimeException("Cannot copy " + from + " -> " + reuse);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte tag = source.readByte();
        target.write((int)tag);
        if (tag == 0) {
            target.writeLong(source.readLong());
            this.typeSerializer.copy(source, target);
        } else if (tag == 1) {
            this.typeSerializer.copy(source, target);
        } else if (tag == 2) {
            target.writeLong(source.readLong());
        } else if (tag == 4) {
            target.writeInt(source.readInt());
        } else if (tag == 3) {
            target.writeLong(source.readLong());
            target.writeLong(source.readLong());
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        } else {
            throw new IOException("Corrupt stream, found tag: " + tag);
        }
    }

    public void serialize(StreamElement value, DataOutputView target) throws IOException {
        if (value.isRecord()) {
            StreamRecord record = value.asRecord();
            if (record.hasTimestamp()) {
                target.write(0);
                target.writeLong(record.getTimestamp());
            } else {
                target.write(1);
            }
            this.typeSerializer.serialize(record.getValue(), target);
        } else if (value.isWatermark()) {
            target.write(2);
            target.writeLong(value.asWatermark().getTimestamp());
        } else if (value.isWatermarkStatus()) {
            target.write(4);
            target.writeInt(value.asWatermarkStatus().getStatus());
        } else if (value.isLatencyMarker()) {
            target.write(3);
            target.writeLong(value.asLatencyMarker().getMarkedTime());
            target.writeLong(value.asLatencyMarker().getOperatorId().getLowerPart());
            target.writeLong(value.asLatencyMarker().getOperatorId().getUpperPart());
            target.writeInt(value.asLatencyMarker().getSubtaskIndex());
        } else {
            throw new RuntimeException();
        }
    }

    public StreamElement deserialize(DataInputView source) throws IOException {
        byte tag = source.readByte();
        if (tag == 0) {
            long timestamp = source.readLong();
            return new StreamRecord<Object>(this.typeSerializer.deserialize(source), timestamp);
        }
        if (tag == 1) {
            return new StreamRecord<Object>(this.typeSerializer.deserialize(source));
        }
        if (tag == 2) {
            return new Watermark(source.readLong());
        }
        if (tag == 4) {
            return new WatermarkStatus(source.readInt());
        }
        if (tag == 3) {
            return new LatencyMarker(source.readLong(), new OperatorID(source.readLong(), source.readLong()), source.readInt());
        }
        throw new IOException("Corrupt stream, found tag: " + tag);
    }

    public StreamElement deserialize(StreamElement reuse, DataInputView source) throws IOException {
        byte tag = source.readByte();
        if (tag == 0) {
            long timestamp = source.readLong();
            Object value = this.typeSerializer.deserialize(source);
            StreamRecord reuseRecord = reuse.asRecord();
            reuseRecord.replace(value, timestamp);
            return reuseRecord;
        }
        if (tag == 1) {
            Object value = this.typeSerializer.deserialize(source);
            StreamRecord reuseRecord = reuse.asRecord();
            reuseRecord.replace(value);
            return reuseRecord;
        }
        if (tag == 2) {
            return new Watermark(source.readLong());
        }
        if (tag == 3) {
            return new LatencyMarker(source.readLong(), new OperatorID(source.readLong(), source.readLong()), source.readInt());
        }
        throw new IOException("Corrupt stream, found tag: " + tag);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamElementSerializer) {
            StreamElementSerializer other = (StreamElementSerializer)((Object)obj);
            return this.typeSerializer.equals(other.typeSerializer);
        }
        return false;
    }

    public int hashCode() {
        return this.typeSerializer.hashCode();
    }

    public StreamElementSerializerSnapshot<T> snapshotConfiguration() {
        return new StreamElementSerializerSnapshot(this);
    }

    public static final class StreamElementSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<StreamElement, StreamElementSerializer<T>> {
        private static final int VERSION = 2;

        public StreamElementSerializerSnapshot() {
            super(StreamElementSerializer.class);
        }

        StreamElementSerializerSnapshot(StreamElementSerializer<T> serializerInstance) {
            super(serializerInstance);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        protected TypeSerializer<?>[] getNestedSerializers(StreamElementSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.getContainedTypeSerializer()};
        }

        protected StreamElementSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> casted = nestedSerializers[0];
            return new StreamElementSerializer(casted);
        }
    }
}

