/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.util.CollectionUtil;

@Experimental
public abstract class RandomGenerator<T>
implements DataGenerator<T> {
    protected transient RandomDataGenerator random;
    protected float nullRate;

    @Override
    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        this.random = new RandomDataGenerator();
    }

    public RandomGenerator<T> withNullRate(float nullRate) {
        this.nullRate = nullRate;
        return this;
    }

    protected T nextWithNullRate(Supplier<T> supplier) {
        if (this.nullRate == 0.0f || this.nullRate < ThreadLocalRandom.current().nextFloat()) {
            return supplier.get();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    public static RandomGenerator<Long> longGenerator(final long min, final long max) {
        return new RandomGenerator<Long>(){

            @Override
            public Long next() {
                return this.nextWithNullRate(() -> this.random.nextLong(min, max));
            }
        };
    }

    public static RandomGenerator<Integer> intGenerator(final int min, final int max) {
        return new RandomGenerator<Integer>(){

            @Override
            public Integer next() {
                return this.nextWithNullRate(() -> this.random.nextInt(min, max));
            }
        };
    }

    public static RandomGenerator<Short> shortGenerator(final short min, final short max) {
        return new RandomGenerator<Short>(){

            @Override
            public Short next() {
                return this.nextWithNullRate(() -> (short)this.random.nextInt((int)min, (int)max));
            }
        };
    }

    public static RandomGenerator<Byte> byteGenerator(final byte min, final byte max) {
        return new RandomGenerator<Byte>(){

            @Override
            public Byte next() {
                return this.nextWithNullRate(() -> (byte)this.random.nextInt((int)min, (int)max));
            }
        };
    }

    public static RandomGenerator<Float> floatGenerator(final float min, final float max) {
        return new RandomGenerator<Float>(){

            @Override
            public Float next() {
                return this.nextWithNullRate(() -> Float.valueOf((float)this.random.nextUniform((double)min, (double)max)));
            }
        };
    }

    public static RandomGenerator<Double> doubleGenerator(final double min, final double max) {
        return new RandomGenerator<Double>(){

            @Override
            public Double next() {
                return this.nextWithNullRate(() -> this.random.nextUniform(min, max));
            }
        };
    }

    public static RandomGenerator<String> stringGenerator(final int len) {
        return new RandomGenerator<String>(){

            @Override
            public String next() {
                return this.nextWithNullRate(() -> this.random.nextHexString(len));
            }
        };
    }

    public static RandomGenerator<Boolean> booleanGenerator() {
        return new RandomGenerator<Boolean>(){

            @Override
            public Boolean next() {
                return this.nextWithNullRate(() -> this.random.nextInt(0, 1) == 0);
            }
        };
    }

    public static <T> RandomGenerator<T[]> arrayGenerator(final DataGenerator<T> generator, final int len) {
        return new RandomGenerator<T[]>(){

            @Override
            public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
                generator.open(name, context, runtimeContext);
            }

            @Override
            public T[] next() {
                Object[] array = new Object[len];
                for (int i = 0; i < len; ++i) {
                    array[i] = generator.next();
                }
                return array;
            }
        };
    }

    public static <K, V> RandomGenerator<Map<K, V>> mapGenerator(final DataGenerator<K> key, final DataGenerator<V> value, final int size) {
        return new RandomGenerator<Map<K, V>>(){

            @Override
            public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
                key.open(name + ".key", context, runtimeContext);
                value.open(name + ".value", context, runtimeContext);
            }

            @Override
            public Map<K, V> next() {
                HashMap map = CollectionUtil.newHashMapWithExpectedSize((int)size);
                for (int i = 0; i < size; ++i) {
                    map.put(key.next(), value.next());
                }
                return map;
            }
        };
    }
}

