/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoFlatMapFunction;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.streaming.api.functions.co.ProcessJoinFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TypeFillTest {
    TypeFillTest() {
    }

    @Test
    void test() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Assertions.assertThatThrownBy(() -> env.addSource(new TestSource()).print()).isInstanceOf(InvalidTypesException.class);
        DataStreamSource source = env.fromSequence(1L, 10L);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$1((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$2((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$3((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$4((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$5((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$6((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$7((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$8((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        Assertions.assertThatThrownBy(() -> TypeFillTest.lambda$test$9((DataStream)source)).isInstanceOf(InvalidTypesException.class);
        env.addSource(new TestSource()).returns(Integer.class);
        source.map(new TestMap()).returns(Long.class).print();
        source.flatMap(new TestFlatMap()).returns((TypeHint)new TypeHint<Long>(){}).print();
        source.connect((DataStream)source).map(new TestCoMap()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO).print();
        source.connect((DataStream)source).flatMap(new TestCoFlatMap()).returns((TypeInformation)BasicTypeInfo.INT_TYPE_INFO).print();
        source.connect((DataStream)source).keyBy(new TestKeySelector(), new TestKeySelector(), Types.STRING);
        source.coGroup((DataStream)source).where(new TestKeySelector(), Types.STRING).equalTo(new TestKeySelector(), Types.STRING);
        source.join((DataStream)source).where(new TestKeySelector(), Types.STRING).equalTo(new TestKeySelector(), Types.STRING);
        source.keyBy((KeySelector & Serializable)in -> in).intervalJoin(source.keyBy((KeySelector & Serializable)in -> in)).between(Time.milliseconds((long)10L), Time.milliseconds((long)10L)).process(new TestProcessJoinFunction()).returns(Types.STRING);
        source.keyBy((KeySelector & Serializable)in -> in).intervalJoin(source.keyBy((KeySelector & Serializable)in -> in)).between(Time.milliseconds((long)10L), Time.milliseconds((long)10L)).process(new TestProcessJoinFunction(), Types.STRING);
        Assertions.assertThat((Object)source.map(new TestMap()).returns(Long.class).getType()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        SingleOutputStreamOperator map = source.map((MapFunction)new MapFunction<Long, String>(){

            public String map(Long value) throws Exception {
                return null;
            }
        });
        map.print();
        Assertions.assertThatThrownBy(() -> map.returns(String.class)).isInstanceOf(IllegalStateException.class);
    }

    private static /* synthetic */ void lambda$test$9(DataStream source) throws Throwable {
        source.keyBy((KeySelector & Serializable)in -> in).intervalJoin(source.keyBy((KeySelector & Serializable)in -> in)).between(Time.milliseconds((long)10L), Time.milliseconds((long)10L)).process(new TestProcessJoinFunction()).print();
    }

    private static /* synthetic */ void lambda$test$8(DataStream source) throws Throwable {
        source.join(source).where(new TestKeySelector()).equalTo(new TestKeySelector());
    }

    private static /* synthetic */ void lambda$test$7(DataStream source) throws Throwable {
        source.coGroup(source).where(new TestKeySelector()).equalTo(new TestKeySelector());
    }

    private static /* synthetic */ void lambda$test$6(DataStream source) throws Throwable {
        source.connect(source).keyBy(new TestKeySelector(), new TestKeySelector());
    }

    private static /* synthetic */ void lambda$test$5(DataStream source) throws Throwable {
        source.keyBy(new TestKeySelector()).print();
    }

    private static /* synthetic */ void lambda$test$4(DataStream source) throws Throwable {
        source.connect(source).flatMap(new TestCoFlatMap()).print();
    }

    private static /* synthetic */ void lambda$test$3(DataStream source) throws Throwable {
        source.connect(source).map(new TestCoMap()).print();
    }

    private static /* synthetic */ void lambda$test$2(DataStream source) throws Throwable {
        source.flatMap(new TestFlatMap()).print();
    }

    private static /* synthetic */ void lambda$test$1(DataStream source) throws Throwable {
        source.map(new TestMap()).print();
    }

    private static class TestProcessJoinFunction<IN1, IN2, OUT>
    extends ProcessJoinFunction<IN1, IN2, OUT> {
        private TestProcessJoinFunction() {
        }

        public void processElement(IN1 left, IN2 right, ProcessJoinFunction.Context ctx, Collector<OUT> out) throws Exception {
        }
    }

    private static class TestKeySelector<IN, KEY>
    implements KeySelector<IN, KEY> {
        private TestKeySelector() {
        }

        public KEY getKey(IN value) throws Exception {
            return null;
        }
    }

    private static class TestCoFlatMap<IN1, IN2, OUT>
    implements CoFlatMapFunction<IN1, IN2, OUT> {
        private TestCoFlatMap() {
        }

        public void flatMap1(IN1 value, Collector<OUT> out) throws Exception {
        }

        public void flatMap2(IN2 value, Collector<OUT> out) throws Exception {
        }
    }

    private static class TestCoMap<IN1, IN2, OUT>
    implements CoMapFunction<IN1, IN2, OUT> {
        private TestCoMap() {
        }

        public OUT map1(IN1 value) {
            return null;
        }

        public OUT map2(IN2 value) {
            return null;
        }
    }

    private static class TestFlatMap<T, O>
    implements FlatMapFunction<T, O> {
        private TestFlatMap() {
        }

        public void flatMap(T value, Collector<O> out) throws Exception {
        }
    }

    private static class TestMap<T, O>
    implements MapFunction<T, O> {
        private TestMap() {
        }

        public O map(T value) throws Exception {
            return null;
        }
    }

    private static class TestSource<T>
    implements SourceFunction<T> {
        private static final long serialVersionUID = 1L;

        private TestSource() {
        }

        public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        }

        public void cancel() {
        }
    }
}

