/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.streaming.runtime.io.benchmark.StreamNetworkThroughputBenchmark;
import org.apache.flink.util.Preconditions;

public class DataSkewStreamNetworkThroughputBenchmark
extends StreamNetworkThroughputBenchmark {
    @Override
    protected void setChannelSelector(RecordWriterBuilder recordWriterBuilder, boolean broadcastMode) {
        Preconditions.checkArgument((!broadcastMode ? 1 : 0) != 0, (Object)"Combining broadcasting with data skew doesn't make sense");
        recordWriterBuilder.setChannelSelector((ChannelSelector)new DataSkewChannelSelector());
    }

    private static class DataSkewChannelSelector
    implements ChannelSelector {
        private int numberOfChannels;
        private int channelIndex = 0;

        private DataSkewChannelSelector() {
        }

        public void setup(int numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        public int selectChannel(IOReadableWritable record) {
            if (this.channelIndex >= this.numberOfChannels) {
                return 0;
            }
            return this.channelIndex++;
        }

        public boolean isBroadcast() {
            return false;
        }
    }
}

