/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyMapTest {
    KeyMapTest() {
    }

    @Test
    void testInitialSizeComputation() {
        KeyMap map = new KeyMap();
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(64);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(6);
        Assertions.assertThat((int)map.getShift()).isEqualTo(24);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(48);
        map = new KeyMap(0);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(64);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(6);
        Assertions.assertThat((int)map.getShift()).isEqualTo(24);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(48);
        map = new KeyMap(1);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(64);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(6);
        Assertions.assertThat((int)map.getShift()).isEqualTo(24);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(48);
        map = new KeyMap(9);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(64);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(6);
        Assertions.assertThat((int)map.getShift()).isEqualTo(24);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(48);
        map = new KeyMap(63);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(64);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(6);
        Assertions.assertThat((int)map.getShift()).isEqualTo(24);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(48);
        map = new KeyMap(64);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(128);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(7);
        Assertions.assertThat((int)map.getShift()).isEqualTo(23);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(96);
        map = new KeyMap(500);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(512);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(9);
        Assertions.assertThat((int)map.getShift()).isEqualTo(21);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(384);
        map = new KeyMap(127);
        Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(128);
        Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(7);
        Assertions.assertThat((int)map.getShift()).isEqualTo(23);
        Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(96);
        Assertions.assertThatThrownBy(() -> new KeyMap(-1)).isInstanceOf(IllegalArgumentException.class);
        try {
            map = new KeyMap(1701926178);
            int maxCap = Integer.highestOneBit(Integer.MAX_VALUE);
            Assertions.assertThat((int)map.getCurrentTableCapacity()).isEqualTo(maxCap);
            Assertions.assertThat((int)map.getLog2TableCapacity()).isEqualTo(30);
            Assertions.assertThat((int)map.getShift()).isZero();
            Assertions.assertThat((int)map.getRehashThreshold()).isEqualTo(maxCap / 4 * 3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    @Test
    void testPutAndGetRandom() {
        Integer key;
        int i;
        KeyMap map = new KeyMap();
        Random rnd = new Random();
        long seed = rnd.nextLong();
        int numElements = 10000;
        HashMap<Integer, Integer> groundTruth = new HashMap<Integer, Integer>();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            key = rnd.nextInt();
            Integer value = rnd.nextInt();
            if (!rnd.nextBoolean()) continue;
            groundTruth.put(key, value);
            map.put((Object)key, (Object)value);
        }
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            key = rnd.nextInt();
            rnd.nextInt();
            rnd.nextBoolean();
            Integer expected = (Integer)groundTruth.get(key);
            if (expected == null) {
                Assertions.assertThat((Integer)((Integer)map.get((Object)key))).isNull();
                continue;
            }
            Integer contained = (Integer)map.get((Object)key);
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)contained).isNotNull()).isEqualTo((Object)expected);
        }
    }

    @Test
    void testConjunctTraversal() throws Exception {
        Random rootRnd = new Random(654685486325439L);
        int numMaps = 7;
        int numKeys = 1000000;
        KeyMap[] maps = new KeyMap[7];
        for (int i = 0; i < 7; ++i) {
            maps[i] = new KeyMap();
        }
        double[] probabilities = new double[7];
        double[] probabilitiesTemp = new double[7];
        probabilities[0] = 0.5;
        double remainingProb = 1.0 - probabilities[0];
        for (int i = 1; i < 6; ++i) {
            probabilities[i] = remainingProb /= 2.0;
        }
        probabilities[6] = remainingProb;
        long probSeed = rootRnd.nextLong();
        long keySeed = rootRnd.nextLong();
        Random probRnd = new Random(probSeed);
        Random keyRnd = new Random(keySeed);
        int maxStride = 2147;
        int totalNumElements = 0;
        int nextKeyValue = 1;
        for (int i = 0; i < 1000000; ++i) {
            int numCopies = nextKeyValue % 3 + 1;
            System.arraycopy(probabilities, 0, probabilitiesTemp, 0, 7);
            double totalProb = 1.0;
            for (int copy = 0; copy < numCopies; ++copy) {
                int pos = KeyMapTest.drawPosProportionally(probabilitiesTemp, totalProb, probRnd);
                totalProb -= probabilitiesTemp[pos];
                probabilitiesTemp[pos] = 0.0;
                Integer boxed = nextKeyValue;
                Integer previous = (Integer)maps[pos].put((Object)boxed, (Object)boxed);
                ((AbstractIntegerAssert)Assertions.assertThat((Integer)previous).as("Test problem - test does not assign unique maps", new Object[0])).isNull();
            }
            totalNumElements += numCopies;
            nextKeyValue += keyRnd.nextInt(2147) + 1;
        }
        int numContained = 0;
        for (KeyMap map : maps) {
            numContained += map.size();
        }
        Assertions.assertThat((int)numContained).isEqualTo(totalNumElements);
        keyRnd.setSeed(keySeed);
        numContained = 0;
        nextKeyValue = 1;
        for (int i = 0; i < 1000000; ++i) {
            int numCopiesExpected = nextKeyValue % 3 + 1;
            int numCopiesContained = 0;
            for (KeyMap map : maps) {
                Integer val = (Integer)map.get((Object)nextKeyValue);
                if (val == null) continue;
                Assertions.assertThat((Integer)val).isEqualTo(nextKeyValue);
                ++numCopiesContained;
            }
            Assertions.assertThat((int)numCopiesContained).isEqualTo(numCopiesExpected);
            numContained += numCopiesContained;
            nextKeyValue += keyRnd.nextInt(2147) + 1;
        }
        Assertions.assertThat((int)numContained).isEqualTo(totalNumElements);
        final int[] keysStartedAndFinished = new int[]{0, 0};
        KeyMap.TraversalEvaluator<Integer, Integer> traversal = new KeyMap.TraversalEvaluator<Integer, Integer>(){
            private int key;
            private int valueCount;

            public void startNewKey(Integer key) {
                this.key = key;
                this.valueCount = 0;
                keysStartedAndFinished[0] = keysStartedAndFinished[0] + 1;
            }

            public void nextValue(Integer value) {
                Assertions.assertThat((Integer)value).isEqualTo(this.key);
                ++this.valueCount;
            }

            public void keyDone() {
                int expected = this.key % 3 + 1;
                ((AbstractIntegerAssert)Assertions.assertThat((int)this.valueCount).as("Wrong count for key " + this.key + " ; expected=" + expected + " , count=" + this.valueCount, new Object[0])).isEqualTo(expected);
                keysStartedAndFinished[1] = keysStartedAndFinished[1] + 1;
            }
        };
        KeyMap.traverseMaps((KeyMap[])KeyMapTest.shuffleArray(maps, rootRnd), (KeyMap.TraversalEvaluator)traversal, (long)17L);
        Assertions.assertThat((int)keysStartedAndFinished[0]).isEqualTo(1000000);
        Assertions.assertThat((int)keysStartedAndFinished[1]).isEqualTo(1000000);
    }

    @Test
    void testSizeComparator() {
        KeyMap map1 = new KeyMap(5);
        KeyMap map2 = new KeyMap(80);
        Assertions.assertThat((int)map1.getCurrentTableCapacity()).isLessThan(map2.getCurrentTableCapacity());
        Assertions.assertThat((int)KeyMap.CapacityDescendingComparator.INSTANCE.compare(map1, map1)).isZero();
        Assertions.assertThat((int)KeyMap.CapacityDescendingComparator.INSTANCE.compare(map2, map2)).isZero();
        Assertions.assertThat((int)KeyMap.CapacityDescendingComparator.INSTANCE.compare(map1, map2)).isPositive();
        Assertions.assertThat((int)KeyMap.CapacityDescendingComparator.INSTANCE.compare(map2, map1)).isNegative();
    }

    private static int drawPosProportionally(double[] array, double totalProbability, Random rnd) {
        double val = rnd.nextDouble() * totalProbability;
        double accum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            if (!(val <= (accum += array[i])) || !(array[i] > 0.0)) continue;
            return i;
        }
        return array.length - 1;
    }

    private static <E> E[] shuffleArray(E[] array, Random rnd) {
        E[] target = Arrays.copyOf(array, array.length);
        for (int i = target.length - 1; i > 0; --i) {
            int swapPos = rnd.nextInt(i + 1);
            E temp = target[i];
            target[i] = target[swapPos];
            target[swapPos] = temp;
        }
        return target;
    }
}

