/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
final class RowWisePartWriter<IN, BucketID>
extends PartFileWriter<IN, BucketID> {
    private final Encoder<IN> encoder;

    private RowWisePartWriter(BucketID bucketId, RecoverableFsDataOutputStream currentPartStream, Encoder<IN> encoder, long creationTime) {
        super(bucketId, currentPartStream, creationTime);
        this.encoder = (Encoder)Preconditions.checkNotNull(encoder);
    }

    @Override
    void write(IN element, long currentTime) throws IOException {
        this.encoder.encode(element, (OutputStream)this.currentPartStream);
        this.markWrite(currentTime);
    }

    static class Factory<IN, BucketID>
    implements PartFileWriter.PartFileFactory<IN, BucketID> {
        private final Encoder<IN> encoder;

        Factory(Encoder<IN> encoder) {
            this.encoder = encoder;
        }

        @Override
        public PartFileWriter<IN, BucketID> resumeFrom(BucketID bucketId, RecoverableFsDataOutputStream stream, RecoverableWriter.ResumeRecoverable resumable, long creationTime) throws IOException {
            Preconditions.checkNotNull((Object)stream);
            Preconditions.checkNotNull((Object)resumable);
            return new RowWisePartWriter(bucketId, stream, this.encoder, creationTime);
        }

        @Override
        public PartFileWriter<IN, BucketID> openNew(BucketID bucketId, RecoverableFsDataOutputStream stream, Path path, long creationTime) throws IOException {
            Preconditions.checkNotNull((Object)stream);
            Preconditions.checkNotNull((Object)path);
            return new RowWisePartWriter(bucketId, stream, this.encoder, creationTime);
        }
    }
}

