/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@PublicEvolving
public final class SimpleVersionedStringSerializer
implements SimpleVersionedSerializer<String> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final SimpleVersionedStringSerializer INSTANCE = new SimpleVersionedStringSerializer();

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(String value) {
        byte[] serialized = value.getBytes(StandardCharsets.UTF_8);
        byte[] targetBytes = new byte[4 + serialized.length];
        ByteBuffer bb = ByteBuffer.wrap(targetBytes).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(serialized.length);
        bb.put(serialized);
        return targetBytes;
    }

    public String deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return SimpleVersionedStringSerializer.deserializeV1(serialized);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private static String deserializeV1(byte[] serialized) {
        ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        byte[] targetStringBytes = new byte[bb.getInt()];
        bb.get(targetStringBytes);
        return new String(targetStringBytes, CHARSET);
    }

    private SimpleVersionedStringSerializer() {
    }
}

