/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.streaming.runtime.io.checkpointing.AbstractAlternatingAlignedBarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingCollectingBarriersUnaligned;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;

final class AlternatingCollectingBarriers
extends AbstractAlternatingAlignedBarrierHandlerState {
    AlternatingCollectingBarriers(ChannelState context) {
        super(context);
    }

    @Override
    public BarrierHandlerState alignmentTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) throws IOException, CheckpointException {
        this.state.prioritizeAllAnnouncements();
        CheckpointBarrier unalignedBarrier = checkpointBarrier.asUnaligned();
        controller.initInputsCheckpoint(unalignedBarrier);
        for (CheckpointableInput input : this.state.getInputs()) {
            input.checkpointStarted(unalignedBarrier);
        }
        controller.triggerGlobalCheckpoint(unalignedBarrier);
        return new AlternatingCollectingBarriersUnaligned(true, this.state);
    }

    @Override
    protected BarrierHandlerState transitionAfterBarrierReceived(ChannelState state) {
        return this;
    }
}

