/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusProvider;
import org.apache.flink.streaming.runtime.tasks.BroadcastingOutputCollector;
import org.apache.flink.util.OutputTag;

final class CopyingBroadcastingOutputCollector<T>
extends BroadcastingOutputCollector<T> {
    public CopyingBroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs, StreamStatusProvider streamStatusProvider) {
        super(outputs, streamStatusProvider);
    }

    @Override
    public void collect(StreamRecord<T> record) {
        for (int i = 0; i < this.outputs.length - 1; ++i) {
            Output output = this.outputs[i];
            StreamRecord<T> shallowCopy = record.copy(record.getValue());
            output.collect(shallowCopy);
        }
        if (this.outputs.length > 0) {
            this.outputs[this.outputs.length - 1].collect(record);
        }
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        for (int i = 0; i < this.outputs.length - 1; ++i) {
            Output output = this.outputs[i];
            StreamRecord<X> shallowCopy = record.copy(record.getValue());
            output.collect(outputTag, shallowCopy);
        }
        if (this.outputs.length > 0) {
            this.outputs[this.outputs.length - 1].collect(outputTag, record);
        }
    }
}

