/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.io.InputProcessorUtil;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StreamInputProcessor<IN> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamInputProcessor.class);
    private final RecordDeserializer<DeserializationDelegate<StreamElement>>[] recordDeserializers;
    private RecordDeserializer<DeserializationDelegate<StreamElement>> currentRecordDeserializer;
    private final DeserializationDelegate<StreamElement> deserializationDelegate;
    private final CheckpointBarrierHandler barrierHandler;
    private final Object lock;
    private StatusWatermarkValve statusWatermarkValve;
    private final int numInputChannels;
    private int currentChannel = -1;
    private final StreamStatusMaintainer streamStatusMaintainer;
    private final OneInputStreamOperator<IN, ?> streamOperator;
    private final WatermarkGauge watermarkGauge;
    private Counter numRecordsIn;
    private boolean isFinished;

    public StreamInputProcessor(InputGate[] inputGates, TypeSerializer<IN> inputSerializer, StreamTask<?, ?> checkpointedTask, CheckpointingMode checkpointMode, Object lock, IOManager ioManager, Configuration taskManagerConfig, StreamStatusMaintainer streamStatusMaintainer, OneInputStreamOperator<IN, ?> streamOperator, TaskIOMetricGroup metrics, WatermarkGauge watermarkGauge) throws IOException {
        InputGate inputGate = InputGateUtil.createInputGate(inputGates);
        this.barrierHandler = InputProcessorUtil.createCheckpointBarrierHandler(checkpointedTask, checkpointMode, ioManager, inputGate, taskManagerConfig);
        this.lock = Preconditions.checkNotNull((Object)lock);
        StreamElementSerializer<IN> ser = new StreamElementSerializer<IN>(inputSerializer);
        this.deserializationDelegate = new NonReusingDeserializationDelegate(ser);
        this.recordDeserializers = new SpillingAdaptiveSpanningRecordDeserializer[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < this.recordDeserializers.length; ++i) {
            this.recordDeserializers[i] = new SpillingAdaptiveSpanningRecordDeserializer(ioManager.getSpillingDirectoriesPaths());
        }
        this.numInputChannels = inputGate.getNumberOfInputChannels();
        this.streamStatusMaintainer = (StreamStatusMaintainer)Preconditions.checkNotNull((Object)streamStatusMaintainer);
        this.streamOperator = (OneInputStreamOperator)Preconditions.checkNotNull(streamOperator);
        this.statusWatermarkValve = new StatusWatermarkValve(this.numInputChannels, new ForwardingValveOutputHandler(streamOperator, lock));
        this.watermarkGauge = watermarkGauge;
        metrics.gauge("checkpointAlignmentTime", this.barrierHandler::getAlignmentDurationNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processInput() throws Exception {
        block19: {
            AbstractEvent event;
            if (this.isFinished) {
                return false;
            }
            if (this.numRecordsIn == null) {
                try {
                    this.numRecordsIn = ((OperatorMetricGroup)this.streamOperator.getMetricGroup()).getIOMetricGroup().getNumRecordsInCounter();
                }
                catch (Exception e) {
                    LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
                    this.numRecordsIn = new SimpleCounter();
                }
            }
            while (true) {
                BufferOrEvent bufferOrEvent;
                if (this.currentRecordDeserializer != null) {
                    RecordDeserializer.DeserializationResult result = this.currentRecordDeserializer.getNextRecord(this.deserializationDelegate);
                    if (result.isBufferConsumed()) {
                        this.currentRecordDeserializer.getCurrentBuffer().recycleBuffer();
                        this.currentRecordDeserializer = null;
                    }
                    if (result.isFullRecord()) {
                        StreamElement recordOrMark = (StreamElement)this.deserializationDelegate.getInstance();
                        if (recordOrMark.isWatermark()) {
                            this.statusWatermarkValve.inputWatermark(recordOrMark.asWatermark(), this.currentChannel);
                            continue;
                        }
                        if (recordOrMark.isStreamStatus()) {
                            this.statusWatermarkValve.inputStreamStatus(recordOrMark.asStreamStatus(), this.currentChannel);
                            continue;
                        }
                        if (recordOrMark.isLatencyMarker()) {
                            Object object = this.lock;
                            synchronized (object) {
                                this.streamOperator.processLatencyMarker(recordOrMark.asLatencyMarker());
                            }
                        }
                        StreamRecord record = recordOrMark.asRecord();
                        Object object = this.lock;
                        synchronized (object) {
                            this.numRecordsIn.inc();
                            this.streamOperator.setKeyContextElement1(record);
                            this.streamOperator.processElement(record);
                        }
                        return true;
                    }
                }
                if ((bufferOrEvent = this.barrierHandler.getNextNonBlocked()) == null) break block19;
                if (bufferOrEvent.isBuffer()) {
                    this.currentChannel = bufferOrEvent.getChannelIndex();
                    this.currentRecordDeserializer = this.recordDeserializers[this.currentChannel];
                    this.currentRecordDeserializer.setNextBuffer(bufferOrEvent.getBuffer());
                    continue;
                }
                event = bufferOrEvent.getEvent();
                if (event.getClass() != EndOfPartitionEvent.class) break;
            }
            throw new IOException("Unexpected event: " + event);
        }
        this.isFinished = true;
        if (!this.barrierHandler.isEmpty()) {
            throw new IllegalStateException("Trailing data in checkpoint barrier handler.");
        }
        return false;
    }

    public void cleanup() throws IOException {
        for (RecordDeserializer<DeserializationDelegate<StreamElement>> deserializer : this.recordDeserializers) {
            Buffer buffer = deserializer.getCurrentBuffer();
            if (buffer != null && !buffer.isRecycled()) {
                buffer.recycleBuffer();
            }
            deserializer.clear();
        }
        this.barrierHandler.cleanup();
    }

    private class ForwardingValveOutputHandler
    implements StatusWatermarkValve.ValveOutputHandler {
        private final OneInputStreamOperator<IN, ?> operator;
        private final Object lock;

        private ForwardingValveOutputHandler(OneInputStreamOperator<IN, ?> operator, Object lock) {
            this.operator = (OneInputStreamOperator)Preconditions.checkNotNull(operator);
            this.lock = Preconditions.checkNotNull((Object)lock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleWatermark(Watermark watermark) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamInputProcessor.this.watermarkGauge.setCurrentWatermark(watermark.getTimestamp());
                    this.operator.processWatermark(watermark);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output watermark: ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStreamStatus(StreamStatus streamStatus) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    StreamInputProcessor.this.streamStatusMaintainer.toggleStreamStatus(streamStatus);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while processing valve output stream status: ", e);
            }
        }
    }
}

