/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.collector.selector.CopyingDirectedOutput;
import org.apache.flink.streaming.api.collector.selector.DirectedOutput;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.io.StreamRecordWriter;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusProvider;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.XORShiftRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OperatorChain<OUT, OP extends StreamOperator<OUT>>
implements StreamStatusMaintainer {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorChain.class);
    private final StreamOperator<?>[] allOperators;
    private final RecordWriterOutput<?>[] streamOutputs;
    private final WatermarkGaugeExposingOutput<StreamRecord<OUT>> chainEntryPoint;
    private final OP headOperator;
    private StreamStatus streamStatus = StreamStatus.ACTIVE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatorChain(StreamTask<OUT, OP> containingTask, List<StreamRecordWriter<SerializationDelegate<StreamRecord<OUT>>>> streamRecordWriters) {
        ClassLoader userCodeClassloader = containingTask.getUserCodeClassLoader();
        StreamConfig configuration = containingTask.getConfiguration();
        this.headOperator = configuration.getStreamOperator(userCodeClassloader);
        Map<Integer, StreamConfig> chainedConfigs = configuration.getTransitiveChainedTaskConfigsWithSelf(userCodeClassloader);
        List<StreamEdge> outEdgesInOrder = configuration.getOutEdgesInOrder(userCodeClassloader);
        HashMap streamOutputMap = new HashMap(outEdgesInOrder.size());
        this.streamOutputs = new RecordWriterOutput[outEdgesInOrder.size()];
        boolean success = false;
        try {
            for (int i = 0; i < outEdgesInOrder.size(); ++i) {
                StreamEdge outEdge = outEdgesInOrder.get(i);
                RecordWriterOutput<OUT> streamOutput = this.createStreamOutput(streamRecordWriters.get(i), outEdge, chainedConfigs.get(outEdge.getSourceId()), containingTask.getEnvironment());
                this.streamOutputs[i] = streamOutput;
                streamOutputMap.put(outEdge, streamOutput);
            }
            ArrayList allOps = new ArrayList(chainedConfigs.size());
            this.chainEntryPoint = this.createOutputCollector(containingTask, configuration, chainedConfigs, userCodeClassloader, streamOutputMap, allOps);
            if (this.headOperator != null) {
                WatermarkGaugeExposingOutput<StreamRecord<OUT>> output = this.getChainEntryPoint();
                this.headOperator.setup(containingTask, configuration, output);
                this.headOperator.getMetricGroup().gauge("currentOutputWatermark", output.getWatermarkGauge());
            }
            allOps.add((StreamOperator<?>)this.headOperator);
            this.allOperators = allOps.toArray(new StreamOperator[allOps.size()]);
            success = true;
        }
        finally {
            if (!success) {
                for (RecordWriterOutput<?> output : this.streamOutputs) {
                    if (output == null) continue;
                    output.close();
                }
            }
        }
    }

    @Override
    public StreamStatus getStreamStatus() {
        return this.streamStatus;
    }

    @Override
    public void toggleStreamStatus(StreamStatus status) {
        if (!status.equals(this.streamStatus)) {
            this.streamStatus = status;
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.emitStreamStatus(status);
            }
        }
    }

    public void broadcastCheckpointBarrier(long id, long timestamp, CheckpointOptions checkpointOptions) throws IOException {
        try {
            CheckpointBarrier barrier = new CheckpointBarrier(id, timestamp, checkpointOptions);
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.broadcastEvent((AbstractEvent)barrier);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while broadcasting checkpoint barrier");
        }
    }

    public void broadcastCheckpointCancelMarker(long id) throws IOException {
        try {
            CancelCheckpointMarker barrier = new CancelCheckpointMarker(id);
            for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                streamOutput.broadcastEvent((AbstractEvent)barrier);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while broadcasting checkpoint cancellation");
        }
    }

    public RecordWriterOutput<?>[] getStreamOutputs() {
        return this.streamOutputs;
    }

    public StreamOperator<?>[] getAllOperators() {
        return this.allOperators;
    }

    public WatermarkGaugeExposingOutput<StreamRecord<OUT>> getChainEntryPoint() {
        return this.chainEntryPoint;
    }

    public void flushOutputs() throws IOException {
        for (RecordWriterOutput<?> streamOutput : this.getStreamOutputs()) {
            streamOutput.flush();
        }
    }

    public void releaseOutputs() {
        for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
            streamOutput.close();
        }
    }

    public OP getHeadOperator() {
        return this.headOperator;
    }

    public int getChainLength() {
        return this.allOperators == null ? 0 : this.allOperators.length;
    }

    private <T> WatermarkGaugeExposingOutput<StreamRecord<T>> createOutputCollector(StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperator<?>> allOperators) {
        ArrayList<Tuple2> allOutputs = new ArrayList<Tuple2>(4);
        for (StreamEdge outputEdge : operatorConfig.getNonChainedOutputs(userCodeClassloader)) {
            RecordWriterOutput<?> output = streamOutputs.get(outputEdge);
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        for (StreamEdge outputEdge : operatorConfig.getChainedOutputs(userCodeClassloader)) {
            int outputId = outputEdge.getTargetId();
            StreamConfig chainedOpConfig = chainedConfigs.get(outputId);
            WatermarkGaugeExposingOutput output = this.createChainedOperator(containingTask, chainedOpConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperators, outputEdge.getOutputTag());
            allOutputs.add(new Tuple2(output, (Object)outputEdge));
        }
        List selectors = operatorConfig.getOutputSelectors(userCodeClassloader);
        if (selectors == null || selectors.isEmpty()) {
            if (allOutputs.size() == 1) {
                return (WatermarkGaugeExposingOutput)((Tuple2)allOutputs.get((int)0)).f0;
            }
            Output[] asArray = new Output[allOutputs.size()];
            for (int i = 0; i < allOutputs.size(); ++i) {
                asArray[i] = (Output)((Tuple2)allOutputs.get((int)i)).f0;
            }
            if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
                return new CopyingBroadcastingOutputCollector(asArray, this);
            }
            return new BroadcastingOutputCollector(asArray, this);
        }
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            return new CopyingDirectedOutput(selectors, allOutputs);
        }
        return new DirectedOutput(selectors, allOutputs);
    }

    private <IN, OUT> WatermarkGaugeExposingOutput<StreamRecord<IN>> createChainedOperator(StreamTask<?, ?> containingTask, StreamConfig operatorConfig, Map<Integer, StreamConfig> chainedConfigs, ClassLoader userCodeClassloader, Map<StreamEdge, RecordWriterOutput<?>> streamOutputs, List<StreamOperator<?>> allOperators, OutputTag<IN> outputTag) {
        ChainingOutput<IN> currentOperatorOutput;
        WatermarkGaugeExposingOutput chainedOperatorOutput = this.createOutputCollector(containingTask, operatorConfig, chainedConfigs, userCodeClassloader, streamOutputs, allOperators);
        OneInputStreamOperator chainedOperator = (OneInputStreamOperator)operatorConfig.getStreamOperator(userCodeClassloader);
        chainedOperator.setup(containingTask, operatorConfig, chainedOperatorOutput);
        allOperators.add(chainedOperator);
        if (containingTask.getExecutionConfig().isObjectReuseEnabled()) {
            currentOperatorOutput = new ChainingOutput<IN>(chainedOperator, this, outputTag);
        } else {
            TypeSerializer inSerializer = operatorConfig.getTypeSerializerIn1(userCodeClassloader);
            currentOperatorOutput = new CopyingChainingOutput<IN>(chainedOperator, inSerializer, outputTag, this);
        }
        chainedOperator.getMetricGroup().gauge("currentInputWatermark", currentOperatorOutput.getWatermarkGauge());
        chainedOperator.getMetricGroup().gauge("currentOutputWatermark", chainedOperatorOutput.getWatermarkGauge());
        return currentOperatorOutput;
    }

    private RecordWriterOutput<OUT> createStreamOutput(StreamRecordWriter<SerializationDelegate<StreamRecord<OUT>>> streamRecordWriter, StreamEdge edge, StreamConfig upStreamConfig, Environment taskEnvironment) {
        OutputTag sideOutputTag = edge.getOutputTag();
        TypeSerializer outSerializer = null;
        outSerializer = edge.getOutputTag() != null ? upStreamConfig.getTypeSerializerSideOut(edge.getOutputTag(), taskEnvironment.getUserClassLoader()) : upStreamConfig.getTypeSerializerOut(taskEnvironment.getUserClassLoader());
        return new RecordWriterOutput<OUT>(streamRecordWriter, outSerializer, sideOutputTag, this);
    }

    private static final class CopyingBroadcastingOutputCollector<T>
    extends BroadcastingOutputCollector<T> {
        public CopyingBroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs, StreamStatusProvider streamStatusProvider) {
            super(outputs, streamStatusProvider);
        }

        @Override
        public void collect(StreamRecord<T> record) {
            for (int i = 0; i < this.outputs.length - 1; ++i) {
                Output output = this.outputs[i];
                StreamRecord<T> shallowCopy = record.copy(record.getValue());
                output.collect(shallowCopy);
            }
            if (this.outputs.length > 0) {
                this.outputs[this.outputs.length - 1].collect(record);
            }
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            for (int i = 0; i < this.outputs.length - 1; ++i) {
                Output output = this.outputs[i];
                StreamRecord<X> shallowCopy = record.copy(record.getValue());
                output.collect(outputTag, shallowCopy);
            }
            if (this.outputs.length > 0) {
                this.outputs[this.outputs.length - 1].collect(outputTag, record);
            }
        }
    }

    private static class BroadcastingOutputCollector<T>
    implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
        protected final Output<StreamRecord<T>>[] outputs;
        private final Random random = new XORShiftRandom();
        private final StreamStatusProvider streamStatusProvider;
        private final WatermarkGauge watermarkGauge = new WatermarkGauge();

        public BroadcastingOutputCollector(Output<StreamRecord<T>>[] outputs, StreamStatusProvider streamStatusProvider) {
            this.outputs = outputs;
            this.streamStatusProvider = streamStatusProvider;
        }

        @Override
        public void emitWatermark(Watermark mark) {
            this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
            if (this.streamStatusProvider.getStreamStatus().isActive()) {
                for (Output<StreamRecord<T>> output : this.outputs) {
                    output.emitWatermark(mark);
                }
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            if (this.outputs.length > 0) {
                if (this.outputs.length == 1) {
                    this.outputs[0].emitLatencyMarker(latencyMarker);
                } else {
                    this.outputs[this.random.nextInt(this.outputs.length)].emitLatencyMarker(latencyMarker);
                }
            }
        }

        @Override
        public Gauge<Long> getWatermarkGauge() {
            return this.watermarkGauge;
        }

        public void collect(StreamRecord<T> record) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.collect(record);
            }
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.collect(outputTag, record);
            }
        }

        public void close() {
            for (Output<StreamRecord<T>> output : this.outputs) {
                output.close();
            }
        }
    }

    private static final class CopyingChainingOutput<T>
    extends ChainingOutput<T> {
        private final TypeSerializer<T> serializer;

        public CopyingChainingOutput(OneInputStreamOperator<T, ?> operator, TypeSerializer<T> serializer, OutputTag<T> outputTag, StreamStatusProvider streamStatusProvider) {
            super(operator, streamStatusProvider, outputTag);
            this.serializer = serializer;
        }

        @Override
        public void collect(StreamRecord<T> record) {
            if (this.outputTag != null) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            if (this.outputTag == null || !this.outputTag.equals(outputTag)) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        protected <X> void pushToOperator(StreamRecord<X> record) {
            try {
                StreamRecord<X> castRecord = record;
                this.numRecordsIn.inc();
                StreamRecord<Object> copy = castRecord.copy(this.serializer.copy(castRecord.getValue()));
                this.operator.setKeyContextElement1(copy);
                this.operator.processElement(copy);
            }
            catch (ClassCastException e) {
                if (this.outputTag != null) {
                    ClassCastException replace = new ClassCastException(String.format("%s. Failed to push OutputTag with id '%s' to operator. This can occur when multiple OutputTags with different types but identical names are being used.", e.getMessage(), this.outputTag.getId()));
                    throw new ExceptionInChainedOperatorException(replace);
                }
                throw new ExceptionInChainedOperatorException(e);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }
    }

    private static class ChainingOutput<T>
    implements WatermarkGaugeExposingOutput<StreamRecord<T>> {
        protected final OneInputStreamOperator<T, ?> operator;
        protected final Counter numRecordsIn;
        protected final WatermarkGauge watermarkGauge = new WatermarkGauge();
        protected final StreamStatusProvider streamStatusProvider;
        protected final OutputTag<T> outputTag;

        public ChainingOutput(OneInputStreamOperator<T, ?> operator, StreamStatusProvider streamStatusProvider, OutputTag<T> outputTag) {
            SimpleCounter tmpNumRecordsIn;
            this.operator = operator;
            try {
                OperatorIOMetricGroup ioMetricGroup = ((OperatorMetricGroup)operator.getMetricGroup()).getIOMetricGroup();
                ioMetricGroup.reuseInputMetricsForTask();
                ioMetricGroup.reuseOutputMetricsForTask();
                tmpNumRecordsIn = ioMetricGroup.getNumRecordsInCounter();
            }
            catch (Exception e) {
                LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
                tmpNumRecordsIn = new SimpleCounter();
            }
            this.numRecordsIn = tmpNumRecordsIn;
            this.streamStatusProvider = streamStatusProvider;
            this.outputTag = outputTag;
        }

        public void collect(StreamRecord<T> record) {
            if (this.outputTag != null) {
                return;
            }
            this.pushToOperator(record);
        }

        @Override
        public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
            if (this.outputTag == null || !this.outputTag.equals(outputTag)) {
                return;
            }
            this.pushToOperator(record);
        }

        protected <X> void pushToOperator(StreamRecord<X> record) {
            try {
                StreamRecord<X> castRecord = record;
                this.numRecordsIn.inc();
                this.operator.setKeyContextElement1(castRecord);
                this.operator.processElement(castRecord);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitWatermark(Watermark mark) {
            try {
                this.watermarkGauge.setCurrentWatermark(mark.getTimestamp());
                if (this.streamStatusProvider.getStreamStatus().isActive()) {
                    this.operator.processWatermark(mark);
                }
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) {
            try {
                this.operator.processLatencyMarker(latencyMarker);
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        public void close() {
            try {
                this.operator.close();
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        @Override
        public Gauge<Long> getWatermarkGauge() {
            return this.watermarkGauge;
        }
    }

    public static interface WatermarkGaugeExposingOutput<T>
    extends Output<T> {
        public Gauge<Long> getWatermarkGauge();
    }
}

