/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;

public class LatencyStats {
    private final Map<String, DescriptiveStatisticsHistogram> latencyStats = new HashMap<String, DescriptiveStatisticsHistogram>();
    private final MetricGroup metricGroup;
    private final int historySize;
    private final int subtaskIndex;
    private final OperatorID operatorId;

    public LatencyStats(MetricGroup metricGroup, int historySize, int subtaskIndex, OperatorID operatorID) {
        this.metricGroup = metricGroup;
        this.historySize = historySize;
        this.subtaskIndex = subtaskIndex;
        this.operatorId = operatorID;
    }

    public void reportLatency(LatencyMarker marker) {
        String uniqueName = "" + marker.getOperatorId() + marker.getSubtaskIndex() + this.operatorId + this.subtaskIndex;
        DescriptiveStatisticsHistogram latencyHistogram = this.latencyStats.get(uniqueName);
        if (latencyHistogram == null) {
            latencyHistogram = new DescriptiveStatisticsHistogram(this.historySize);
            this.latencyStats.put(uniqueName, latencyHistogram);
            this.metricGroup.addGroup("source_id", String.valueOf(marker.getOperatorId())).addGroup("source_subtask_index", String.valueOf(marker.getSubtaskIndex())).addGroup("operator_id", String.valueOf(this.operatorId)).addGroup("operator_subtask_index", String.valueOf(this.subtaskIndex)).histogram("latency", (Histogram)latencyHistogram);
        }
        long now = System.currentTimeMillis();
        latencyHistogram.update(now - marker.getMarkedTime());
    }
}

