/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.CorruptConfigurationException;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.util.ClassLoaderUtil;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.tasks.StreamTaskException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NUMBER_OF_OUTPUTS = "numberOfOutputs";
    private static final String NUMBER_OF_INPUTS = "numberOfInputs";
    private static final String CHAINED_OUTPUTS = "chainedOutputs";
    private static final String CHAINED_TASK_CONFIG = "chainedTaskConfig_";
    private static final String IS_CHAINED_VERTEX = "isChainedSubtask";
    private static final String CHAIN_INDEX = "chainIndex";
    private static final String VERTEX_NAME = "vertexID";
    private static final String ITERATION_ID = "iterationId";
    private static final String OUTPUT_SELECTOR_WRAPPER = "outputSelectorWrapper";
    private static final String SERIALIZEDUDF = "serializedUDF";
    private static final String USER_FUNCTION = "userFunction";
    private static final String BUFFER_TIMEOUT = "bufferTimeout";
    private static final String TYPE_SERIALIZER_IN_1 = "typeSerializer_in_1";
    private static final String TYPE_SERIALIZER_IN_2 = "typeSerializer_in_2";
    private static final String TYPE_SERIALIZER_OUT_1 = "typeSerializer_out";
    private static final String TYPE_SERIALIZER_SIDEOUT_PREFIX = "typeSerializer_sideout_";
    private static final String ITERATON_WAIT = "iterationWait";
    private static final String NONCHAINED_OUTPUTS = "nonChainedOutputs";
    private static final String EDGES_IN_ORDER = "edgesInOrder";
    private static final String OUT_STREAM_EDGES = "outStreamEdges";
    private static final String IN_STREAM_EDGES = "inStreamEdges";
    private static final String OPERATOR_NAME = "operatorName";
    private static final String OPERATOR_ID = "operatorID";
    private static final String CHAIN_END = "chainEnd";
    private static final String CHECKPOINTING_ENABLED = "checkpointing";
    private static final String CHECKPOINT_MODE = "checkpointMode";
    private static final String STATE_BACKEND = "statebackend";
    private static final String STATE_PARTITIONER = "statePartitioner";
    private static final String STATE_KEY_SERIALIZER = "statekeyser";
    private static final String TIME_CHARACTERISTIC = "timechar";
    private static final long DEFAULT_TIMEOUT = 100L;
    private static final CheckpointingMode DEFAULT_CHECKPOINTING_MODE = CheckpointingMode.EXACTLY_ONCE;
    private final Configuration config;

    public StreamConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setVertexID(Integer vertexID) {
        this.config.setInteger(VERTEX_NAME, vertexID.intValue());
    }

    public Integer getVertexID() {
        return this.config.getInteger(VERTEX_NAME, -1);
    }

    public void setTimeCharacteristic(TimeCharacteristic characteristic) {
        this.config.setInteger(TIME_CHARACTERISTIC, characteristic.ordinal());
    }

    public TimeCharacteristic getTimeCharacteristic() {
        int ordinal = this.config.getInteger(TIME_CHARACTERISTIC, -1);
        if (ordinal >= 0) {
            return TimeCharacteristic.values()[ordinal];
        }
        throw new CorruptConfigurationException("time characteristic is not set");
    }

    public void setTypeSerializerIn1(TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_IN_1, serializer);
    }

    public void setTypeSerializerIn2(TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_IN_2, serializer);
    }

    public void setTypeSerializerOut(TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_OUT_1, serializer);
    }

    public void setTypeSerializerSideOut(OutputTag<?> outputTag, TypeSerializer<?> serializer) {
        this.setTypeSerializer(TYPE_SERIALIZER_SIDEOUT_PREFIX + outputTag.getId(), serializer);
    }

    public <T> TypeSerializer<T> getTypeSerializerIn1(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_IN_1, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    public <T> TypeSerializer<T> getTypeSerializerIn2(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_IN_2, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    public <T> TypeSerializer<T> getTypeSerializerOut(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)TYPE_SERIALIZER_OUT_1, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    public <T> TypeSerializer<T> getTypeSerializerSideOut(OutputTag<?> outputTag, ClassLoader cl) {
        Preconditions.checkNotNull(outputTag, (String)"Side output id must not be null.");
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)(TYPE_SERIALIZER_SIDEOUT_PREFIX + outputTag.getId()), (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate serializer.", e);
        }
    }

    private void setTypeSerializer(String key, TypeSerializer<?> typeWrapper) {
        try {
            InstantiationUtil.writeObjectToConfig(typeWrapper, (Configuration)this.config, (String)key);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize type serializer.", e);
        }
    }

    public void setBufferTimeout(long timeout) {
        this.config.setLong(BUFFER_TIMEOUT, timeout);
    }

    public long getBufferTimeout() {
        return this.config.getLong(BUFFER_TIMEOUT, 100L);
    }

    public boolean isFlushAlwaysEnabled() {
        return this.getBufferTimeout() == 0L;
    }

    public void setStreamOperator(StreamOperator<?> operator) {
        if (operator != null) {
            this.config.setClass(USER_FUNCTION, operator.getClass());
            try {
                InstantiationUtil.writeObjectToConfig(operator, (Configuration)this.config, (String)SERIALIZEDUDF);
            }
            catch (IOException e) {
                throw new StreamTaskException("Cannot serialize operator object " + operator.getClass() + ".", e);
            }
        }
    }

    public <T extends StreamOperator<?>> T getStreamOperator(ClassLoader cl) {
        try {
            return (T)((StreamOperator)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)SERIALIZEDUDF, (ClassLoader)cl));
        }
        catch (ClassNotFoundException e) {
            String classLoaderInfo = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)cl);
            boolean loadableDoubleCheck = ClassLoaderUtil.validateClassLoadable((ClassNotFoundException)e, (ClassLoader)cl);
            String exceptionMessage = "Cannot load user class: " + e.getMessage() + "\nClassLoader info: " + classLoaderInfo + (loadableDoubleCheck ? "\nClass was actually found in classloader - deserialization issue." : "\nClass not resolvable through given classloader.");
            throw new StreamTaskException(exceptionMessage);
        }
        catch (Exception e) {
            throw new StreamTaskException("Cannot instantiate user function.", e);
        }
    }

    public void setOutputSelectors(List<OutputSelector<?>> outputSelectors) {
        try {
            InstantiationUtil.writeObjectToConfig(outputSelectors, (Configuration)this.config, (String)OUTPUT_SELECTOR_WRAPPER);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize output selectors", e);
        }
    }

    public <T> List<OutputSelector<T>> getOutputSelectors(ClassLoader userCodeClassloader) {
        try {
            List selectors = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)OUTPUT_SELECTOR_WRAPPER, (ClassLoader)userCodeClassloader);
            return selectors == null ? Collections.emptyList() : selectors;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not read output selectors", e);
        }
    }

    public void setIterationId(String iterationId) {
        this.config.setString(ITERATION_ID, iterationId);
    }

    public String getIterationId() {
        return this.config.getString(ITERATION_ID, "");
    }

    public void setIterationWaitTime(long time) {
        this.config.setLong(ITERATON_WAIT, time);
    }

    public long getIterationWaitTime() {
        return this.config.getLong(ITERATON_WAIT, 0L);
    }

    public void setNumberOfInputs(int numberOfInputs) {
        this.config.setInteger(NUMBER_OF_INPUTS, numberOfInputs);
    }

    public int getNumberOfInputs() {
        return this.config.getInteger(NUMBER_OF_INPUTS, 0);
    }

    public void setNumberOfOutputs(int numberOfOutputs) {
        this.config.setInteger(NUMBER_OF_OUTPUTS, numberOfOutputs);
    }

    public int getNumberOfOutputs() {
        return this.config.getInteger(NUMBER_OF_OUTPUTS, 0);
    }

    public void setNonChainedOutputs(List<StreamEdge> outputvertexIDs) {
        try {
            InstantiationUtil.writeObjectToConfig(outputvertexIDs, (Configuration)this.config, (String)NONCHAINED_OUTPUTS);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize non chained outputs.", e);
        }
    }

    public List<StreamEdge> getNonChainedOutputs(ClassLoader cl) {
        try {
            List nonChainedOutputs = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)NONCHAINED_OUTPUTS, (ClassLoader)cl);
            return nonChainedOutputs == null ? new ArrayList() : nonChainedOutputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate non chained outputs.", e);
        }
    }

    public void setChainedOutputs(List<StreamEdge> chainedOutputs) {
        try {
            InstantiationUtil.writeObjectToConfig(chainedOutputs, (Configuration)this.config, (String)CHAINED_OUTPUTS);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize chained outputs.", e);
        }
    }

    public List<StreamEdge> getChainedOutputs(ClassLoader cl) {
        try {
            List chainedOutputs = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAINED_OUTPUTS, (ClassLoader)cl);
            return chainedOutputs == null ? new ArrayList() : chainedOutputs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate chained outputs.", e);
        }
    }

    public void setOutEdges(List<StreamEdge> outEdges) {
        try {
            InstantiationUtil.writeObjectToConfig(outEdges, (Configuration)this.config, (String)OUT_STREAM_EDGES);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize outward edges.", e);
        }
    }

    public List<StreamEdge> getOutEdges(ClassLoader cl) {
        try {
            List outEdges = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)OUT_STREAM_EDGES, (ClassLoader)cl);
            return outEdges == null ? new ArrayList() : outEdges;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate outputs.", e);
        }
    }

    public void setInPhysicalEdges(List<StreamEdge> inEdges) {
        try {
            InstantiationUtil.writeObjectToConfig(inEdges, (Configuration)this.config, (String)IN_STREAM_EDGES);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize inward edges.", e);
        }
    }

    public List<StreamEdge> getInPhysicalEdges(ClassLoader cl) {
        try {
            List inEdges = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)IN_STREAM_EDGES, (ClassLoader)cl);
            return inEdges == null ? new ArrayList() : inEdges;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate inputs.", e);
        }
    }

    public void setCheckpointingEnabled(boolean enabled) {
        this.config.setBoolean(CHECKPOINTING_ENABLED, enabled);
    }

    public boolean isCheckpointingEnabled() {
        return this.config.getBoolean(CHECKPOINTING_ENABLED, false);
    }

    public void setCheckpointMode(CheckpointingMode mode) {
        this.config.setInteger(CHECKPOINT_MODE, mode.ordinal());
    }

    public CheckpointingMode getCheckpointMode() {
        int ordinal = this.config.getInteger(CHECKPOINT_MODE, -1);
        if (ordinal >= 0) {
            return CheckpointingMode.values()[ordinal];
        }
        return DEFAULT_CHECKPOINTING_MODE;
    }

    public void setOutEdgesInOrder(List<StreamEdge> outEdgeList) {
        try {
            InstantiationUtil.writeObjectToConfig(outEdgeList, (Configuration)this.config, (String)EDGES_IN_ORDER);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize outputs in order.", e);
        }
    }

    public List<StreamEdge> getOutEdgesInOrder(ClassLoader cl) {
        try {
            List outEdgesInOrder = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)EDGES_IN_ORDER, (ClassLoader)cl);
            return outEdgesInOrder == null ? new ArrayList() : outEdgesInOrder;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate outputs in order.", e);
        }
    }

    public void setTransitiveChainedTaskConfigs(Map<Integer, StreamConfig> chainedTaskConfigs) {
        try {
            InstantiationUtil.writeObjectToConfig(chainedTaskConfigs, (Configuration)this.config, (String)CHAINED_TASK_CONFIG);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize configuration.", e);
        }
    }

    public Map<Integer, StreamConfig> getTransitiveChainedTaskConfigs(ClassLoader cl) {
        try {
            Map confs = (Map)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAINED_TASK_CONFIG, (ClassLoader)cl);
            return confs == null ? new HashMap() : confs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate configuration.", e);
        }
    }

    public Map<Integer, StreamConfig> getTransitiveChainedTaskConfigsWithSelf(ClassLoader cl) {
        Map<Integer, StreamConfig> chainedTaskConfigs = this.getTransitiveChainedTaskConfigs(cl);
        chainedTaskConfigs.put(this.getVertexID(), this);
        return chainedTaskConfigs;
    }

    public void setOperatorID(OperatorID operatorID) {
        this.config.setBytes(OPERATOR_ID, operatorID.getBytes());
    }

    public OperatorID getOperatorID() {
        byte[] operatorIDBytes = this.config.getBytes(OPERATOR_ID, null);
        return new OperatorID((byte[])Preconditions.checkNotNull((Object)operatorIDBytes));
    }

    public void setOperatorName(String name) {
        this.config.setString(OPERATOR_NAME, name);
    }

    public String getOperatorName() {
        return this.config.getString(OPERATOR_NAME, null);
    }

    public void setChainIndex(int index) {
        this.config.setInteger(CHAIN_INDEX, index);
    }

    public int getChainIndex() {
        return this.config.getInteger(CHAIN_INDEX, 0);
    }

    public void setStateBackend(StateBackend backend) {
        if (backend != null) {
            try {
                InstantiationUtil.writeObjectToConfig((Object)backend, (Configuration)this.config, (String)STATE_BACKEND);
            }
            catch (Exception e) {
                throw new StreamTaskException("Could not serialize stateHandle provider.", e);
            }
        }
    }

    public StateBackend getStateBackend(ClassLoader cl) {
        try {
            return (StateBackend)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)STATE_BACKEND, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate statehandle provider.", e);
        }
    }

    public byte[] getSerializedStateBackend() {
        return this.config.getBytes(STATE_BACKEND, null);
    }

    public void setStatePartitioner(int input, KeySelector<?, ?> partitioner) {
        try {
            InstantiationUtil.writeObjectToConfig(partitioner, (Configuration)this.config, (String)(STATE_PARTITIONER + input));
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize state partitioner.", e);
        }
    }

    public KeySelector<?, Serializable> getStatePartitioner(int input, ClassLoader cl) {
        try {
            return (KeySelector)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)(STATE_PARTITIONER + input), (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate state partitioner.", e);
        }
    }

    public void setStateKeySerializer(TypeSerializer<?> serializer) {
        try {
            InstantiationUtil.writeObjectToConfig(serializer, (Configuration)this.config, (String)STATE_KEY_SERIALIZER);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize state key serializer.", e);
        }
    }

    public <K> TypeSerializer<K> getStateKeySerializer(ClassLoader cl) {
        try {
            return (TypeSerializer)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)STATE_KEY_SERIALIZER, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate state key serializer from task config.", e);
        }
    }

    public void setChainStart() {
        this.config.setBoolean(IS_CHAINED_VERTEX, true);
    }

    public boolean isChainStart() {
        return this.config.getBoolean(IS_CHAINED_VERTEX, false);
    }

    public void setChainEnd() {
        this.config.setBoolean(CHAIN_END, true);
    }

    public boolean isChainEnd() {
        return this.config.getBoolean(CHAIN_END, false);
    }

    public String toString() {
        ClassLoader cl = this.getClass().getClassLoader();
        StringBuilder builder = new StringBuilder();
        builder.append("\n=======================");
        builder.append("Stream Config");
        builder.append("=======================");
        builder.append("\nNumber of non-chained inputs: ").append(this.getNumberOfInputs());
        builder.append("\nNumber of non-chained outputs: ").append(this.getNumberOfOutputs());
        builder.append("\nOutput names: ").append(this.getNonChainedOutputs(cl));
        builder.append("\nPartitioning:");
        for (StreamEdge output : this.getNonChainedOutputs(cl)) {
            int outputname = output.getTargetId();
            builder.append("\n\t").append(outputname).append(": ").append(output.getPartitioner());
        }
        builder.append("\nChained subtasks: ").append(this.getChainedOutputs(cl));
        try {
            builder.append("\nOperator: ").append(this.getStreamOperator(cl).getClass().getSimpleName());
        }
        catch (Exception e) {
            builder.append("\nOperator: Missing");
        }
        builder.append("\nBuffer timeout: ").append(this.getBufferTimeout());
        builder.append("\nState Monitoring: ").append(this.isCheckpointingEnabled());
        if (this.isChainStart() && this.getChainedOutputs(cl).size() > 0) {
            builder.append("\n\n\n---------------------\nChained task configs\n---------------------\n");
            builder.append(this.getTransitiveChainedTaskConfigs(cl));
        }
        return builder.toString();
    }
}

