/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyGroupsList;
import org.apache.flink.streaming.api.operators.HeapInternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimerServiceSerializationProxy;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalTimeServiceManager<K, N> {
    private final int totalKeyGroups;
    private final KeyGroupsList localKeyGroupRange;
    private final KeyContext keyContext;
    private final ProcessingTimeService processingTimeService;
    private final Map<String, HeapInternalTimerService<K, N>> timerServices;

    InternalTimeServiceManager(int totalKeyGroups, KeyGroupsList localKeyGroupRange, KeyContext keyContext, ProcessingTimeService processingTimeService) {
        Preconditions.checkArgument((totalKeyGroups > 0 ? 1 : 0) != 0);
        this.totalKeyGroups = totalKeyGroups;
        this.localKeyGroupRange = (KeyGroupsList)Preconditions.checkNotNull((Object)localKeyGroupRange);
        this.keyContext = (KeyContext)Preconditions.checkNotNull((Object)keyContext);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.timerServices = new HashMap<String, HeapInternalTimerService<K, N>>();
    }

    public InternalTimerService<N> getInternalTimerService(String name, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, Triggerable<K, N> triggerable) {
        HeapInternalTimerService<K, N> timerService = this.timerServices.get(name);
        if (timerService == null) {
            timerService = new HeapInternalTimerService(this.totalKeyGroups, this.localKeyGroupRange, this.keyContext, this.processingTimeService);
            this.timerServices.put(name, timerService);
        }
        timerService.startTimerService(keySerializer, namespaceSerializer, triggerable);
        return timerService;
    }

    public void advanceWatermark(Watermark watermark) throws Exception {
        for (HeapInternalTimerService<K, N> service : this.timerServices.values()) {
            service.advanceWatermark(watermark.getTimestamp());
        }
    }

    public void snapshotStateForKeyGroup(DataOutputView stream, int keyGroupIdx) throws IOException {
        InternalTimerServiceSerializationProxy<K, N> serializationProxy = new InternalTimerServiceSerializationProxy<K, N>(this.timerServices, keyGroupIdx);
        serializationProxy.write(stream);
    }

    public void restoreStateForKeyGroup(InputStream stream, int keyGroupIdx, ClassLoader userCodeClassLoader) throws IOException {
        InternalTimerServiceSerializationProxy<K, N> serializationProxy = new InternalTimerServiceSerializationProxy<K, N>(this.timerServices, userCodeClassLoader, this.totalKeyGroups, this.localKeyGroupRange, this.keyContext, this.processingTimeService, keyGroupIdx);
        serializationProxy.read(stream);
    }

    @VisibleForTesting
    public int numProcessingTimeTimers() {
        int count = 0;
        for (HeapInternalTimerService<K, N> timerService : this.timerServices.values()) {
            count += timerService.numProcessingTimeTimers();
        }
        return count;
    }

    @VisibleForTesting
    public int numEventTimeTimers() {
        int count = 0;
        for (HeapInternalTimerService<K, N> timerService : this.timerServices.values()) {
            count += timerService.numEventTimeTimers();
        }
        return count;
    }
}

