/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class FromElementsFunction<T>
implements SourceFunction<T>,
CheckpointedFunction {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;
    private final byte[] elementsSerialized;
    private final int numElements;
    private volatile int numElementsEmitted;
    private volatile int numElementsToSkip;
    private volatile boolean isRunning = true;
    private transient ListState<Integer> checkpointedState;

    public FromElementsFunction(TypeSerializer<T> serializer, T ... elements) throws IOException {
        this(serializer, (Iterable<T>)Arrays.asList(elements));
    }

    public FromElementsFunction(TypeSerializer<T> serializer, Iterable<T> elements) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
        int count = 0;
        try {
            for (T element : elements) {
                serializer.serialize(element, (DataOutputView)wrapper);
                ++count;
            }
        }
        catch (Exception e) {
            throw new IOException("Serializing the source elements failed: " + e.getMessage(), e);
        }
        this.serializer = serializer;
        this.elementsSerialized = baos.toByteArray();
        this.numElements = count;
    }

    @Override
    public void initializeState(FunctionInitializationContext context) throws Exception {
        Preconditions.checkState((this.checkpointedState == null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " has already been initialized."));
        this.checkpointedState = context.getOperatorStateStore().getListState(new ListStateDescriptor("from-elements-state", (TypeSerializer)IntSerializer.INSTANCE));
        if (context.isRestored()) {
            ArrayList<Integer> retrievedStates = new ArrayList<Integer>();
            for (Integer entry : (Iterable)this.checkpointedState.get()) {
                retrievedStates.add(entry);
            }
            Preconditions.checkArgument((retrievedStates.size() == 1 ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " retrieved invalid state."));
            this.numElementsToSkip = (Integer)retrievedStates.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.elementsSerialized);
        DataInputViewStreamWrapper input = new DataInputViewStreamWrapper((InputStream)bais);
        int toSkip = this.numElementsToSkip;
        if (toSkip > 0) {
            try {
                while (toSkip > 0) {
                    this.serializer.deserialize((DataInputView)input);
                    --toSkip;
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to deserialize an element from the source. If you are using user-defined serialization (Value and Writable types), check the serialization functions.\nSerializer is " + this.serializer);
            }
            this.numElementsEmitted = this.numElementsToSkip;
        }
        Object lock = ctx.getCheckpointLock();
        while (this.isRunning && this.numElementsEmitted < this.numElements) {
            Object next;
            try {
                next = this.serializer.deserialize((DataInputView)input);
            }
            catch (Exception e) {
                throw new IOException("Failed to deserialize an element from the source. If you are using user-defined serialization (Value and Writable types), check the serialization functions.\nSerializer is " + this.serializer);
            }
            Object object = lock;
            synchronized (object) {
                ctx.collect(next);
                ++this.numElementsEmitted;
            }
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public int getNumElementsEmitted() {
        return this.numElementsEmitted;
    }

    @Override
    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        Preconditions.checkState((this.checkpointedState != null ? 1 : 0) != 0, (Object)("The " + this.getClass().getSimpleName() + " has not been properly initialized."));
        this.checkpointedState.clear();
        this.checkpointedState.add((Object)this.numElementsEmitted);
    }

    public static <OUT> void checkCollection(Collection<OUT> elements, Class<OUT> viewedAs) {
        for (OUT elem : elements) {
            if (elem == null) {
                throw new IllegalArgumentException("The collection contains a null element");
            }
            if (viewedAs.isAssignableFrom(elem.getClass())) continue;
            throw new IllegalArgumentException("The elements in the collection are not all subclasses of " + viewedAs.getCanonicalName());
        }
    }
}

