/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.StreamOperator;

@Internal
public class JSONGenerator {
    public static final String STEPS = "step_function";
    public static final String ID = "id";
    public static final String SIDE = "side";
    public static final String SHIP_STRATEGY = "ship_strategy";
    public static final String PREDECESSORS = "predecessors";
    public static final String TYPE = "type";
    public static final String PACT = "pact";
    public static final String CONTENTS = "contents";
    public static final String PARALLELISM = "parallelism";
    private StreamGraph streamGraph;
    private final ObjectMapper mapper = new ObjectMapper();

    public JSONGenerator(StreamGraph streamGraph) {
        this.streamGraph = streamGraph;
    }

    public String getJSON() {
        ObjectNode json = this.mapper.createObjectNode();
        ArrayNode nodes = this.mapper.createArrayNode();
        json.put("nodes", (JsonNode)nodes);
        ArrayList<Integer> operatorIDs = new ArrayList<Integer>(this.streamGraph.getVertexIDs());
        Collections.sort(operatorIDs, new Comparator<Integer>(){

            @Override
            public int compare(Integer idOne, Integer idTwo) {
                boolean isIdTwoSinkId;
                boolean isIdOneSinkId = JSONGenerator.this.streamGraph.getSinkIDs().contains(idOne);
                if (isIdOneSinkId == (isIdTwoSinkId = JSONGenerator.this.streamGraph.getSinkIDs().contains(idTwo))) {
                    return idOne.compareTo(idTwo);
                }
                if (isIdOneSinkId) {
                    return 1;
                }
                return -1;
            }
        });
        this.visit(nodes, operatorIDs, new HashMap<Integer, Integer>());
        return json.toString();
    }

    private void visit(ArrayNode jsonArray, List<Integer> toVisit, Map<Integer, Integer> edgeRemapings) {
        Integer vertexID = toVisit.get(0);
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        if (this.streamGraph.getSourceIDs().contains(vertexID) || Collections.disjoint(vertex.getInEdges(), toVisit)) {
            ObjectNode node = this.mapper.createObjectNode();
            this.decorateNode(vertexID, node);
            if (!this.streamGraph.getSourceIDs().contains(vertexID)) {
                ArrayNode inputs = this.mapper.createArrayNode();
                node.put(PREDECESSORS, (JsonNode)inputs);
                for (StreamEdge inEdge : vertex.getInEdges()) {
                    int inputID = inEdge.getSourceId();
                    Integer mappedID = edgeRemapings.keySet().contains(inputID) ? edgeRemapings.get(inputID) : Integer.valueOf(inputID);
                    this.decorateEdge(inputs, inEdge, mappedID);
                }
            }
            jsonArray.add((JsonNode)node);
            toVisit.remove(vertexID);
        } else {
            Integer iterationHead = -1;
            for (StreamEdge inEdge : vertex.getInEdges()) {
                int operator = inEdge.getSourceId();
                if (!this.streamGraph.vertexIDtoLoopTimeout.containsKey(operator)) continue;
                iterationHead = operator;
            }
            ObjectNode obj = this.mapper.createObjectNode();
            ArrayNode iterationSteps = this.mapper.createArrayNode();
            obj.put(STEPS, (JsonNode)iterationSteps);
            obj.put(ID, iterationHead);
            obj.put(PACT, "IterativeDataStream");
            obj.put(PARALLELISM, this.streamGraph.getStreamNode(iterationHead).getParallelism());
            obj.put(CONTENTS, "Stream Iteration");
            ArrayNode iterationInputs = this.mapper.createArrayNode();
            obj.put(PREDECESSORS, (JsonNode)iterationInputs);
            toVisit.remove(iterationHead);
            this.visitIteration(iterationSteps, toVisit, iterationHead, edgeRemapings, iterationInputs);
            jsonArray.add((JsonNode)obj);
        }
        if (!toVisit.isEmpty()) {
            this.visit(jsonArray, toVisit, edgeRemapings);
        }
    }

    private void visitIteration(ArrayNode jsonArray, List<Integer> toVisit, int headId, Map<Integer, Integer> edgeRemapings, ArrayNode iterationInEdges) {
        Integer vertexID = toVisit.get(0);
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        toVisit.remove(vertexID);
        if (!this.streamGraph.vertexIDtoLoopTimeout.containsKey(vertexID)) {
            ObjectNode obj = this.mapper.createObjectNode();
            jsonArray.add((JsonNode)obj);
            this.decorateNode(vertexID, obj);
            ArrayNode inEdges = this.mapper.createArrayNode();
            obj.put(PREDECESSORS, (JsonNode)inEdges);
            for (StreamEdge inEdge : vertex.getInEdges()) {
                int inputID = inEdge.getSourceId();
                if (edgeRemapings.keySet().contains(inputID)) {
                    this.decorateEdge(inEdges, inEdge, inputID);
                    continue;
                }
                if (this.streamGraph.vertexIDtoLoopTimeout.containsKey(inputID)) continue;
                this.decorateEdge(iterationInEdges, inEdge, inputID);
            }
            edgeRemapings.put(vertexID, headId);
            this.visitIteration(jsonArray, toVisit, headId, edgeRemapings, iterationInEdges);
        }
    }

    private void decorateEdge(ArrayNode inputArray, StreamEdge inEdge, int mappedInputID) {
        ObjectNode input = this.mapper.createObjectNode();
        inputArray.add((JsonNode)input);
        input.put(ID, mappedInputID);
        input.put(SHIP_STRATEGY, inEdge.getPartitioner().toString());
        input.put(SIDE, inputArray.size() == 0 ? "first" : "second");
    }

    private void decorateNode(Integer vertexID, ObjectNode node) {
        StreamNode vertex = this.streamGraph.getStreamNode(vertexID);
        node.put(ID, vertexID);
        node.put(TYPE, vertex.getOperatorName());
        if (this.streamGraph.getSourceIDs().contains(vertexID)) {
            node.put(PACT, "Data Source");
        } else if (this.streamGraph.getSinkIDs().contains(vertexID)) {
            node.put(PACT, "Data Sink");
        } else {
            node.put(PACT, "Operator");
        }
        StreamOperator<?> operator = this.streamGraph.getStreamNode(vertexID).getOperator();
        node.put(CONTENTS, vertex.getOperatorName());
        node.put(PARALLELISM, this.streamGraph.getStreamNode(vertexID).getParallelism());
    }
}

