/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public final class InputSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final InputSelection ALL = new InputSelection(-1L, Boolean.TRUE);
    public static final InputSelection FIRST = new Builder().select(1).build();
    public static final InputSelection SECOND = new Builder().select(2).build();
    private final long inputMask;
    private final boolean isALLMaskOf2;

    private InputSelection(long inputMask, boolean isALLMaskOf2) {
        this.inputMask = inputMask;
        this.isALLMaskOf2 = isALLMaskOf2;
    }

    public long getInputMask() {
        return this.inputMask;
    }

    public boolean isInputSelected(int inputId) {
        return (this.inputMask & 1L << inputId - 1) != 0L;
    }

    public boolean areAllInputsSelected() {
        return this.inputMask == -1L;
    }

    public boolean isALLMaskOf2() {
        return this.isALLMaskOf2;
    }

    public int fairSelectNextIndexOutOf2(int availableInputsMask, int lastReadInputIndex) {
        int selectionMask = (int)this.inputMask;
        int combineMask = availableInputsMask & selectionMask;
        if (combineMask == 3) {
            return lastReadInputIndex == 0 ? 1 : 0;
        }
        if (combineMask >= 0 && combineMask < 3) {
            return combineMask - 1;
        }
        throw new UnsupportedOperationException("Only two inputs are supported.");
    }

    private static boolean isALLMaskOf2(long inputMask) {
        return (3L & inputMask) == 3L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSelection that = (InputSelection)o;
        return this.inputMask == that.inputMask;
    }

    public String toString() {
        return String.valueOf(this.inputMask);
    }

    public static final class Builder {
        private long inputMask = 0L;

        public static Builder from(InputSelection selection) {
            Builder builder = new Builder();
            builder.inputMask = selection.inputMask;
            return builder;
        }

        public Builder select(int inputId) {
            if (inputId > 0 && inputId <= 64) {
                this.inputMask |= 1L << inputId - 1;
            } else if ((long)inputId == -1L) {
                this.inputMask = -1L;
            } else {
                throw new IllegalArgumentException("The inputId must be in the range of 1 to 64, or be -1.");
            }
            return this;
        }

        public InputSelection build() {
            return new InputSelection(this.inputMask, InputSelection.isALLMaskOf2(this.inputMask));
        }
    }
}

