/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupedInternalPriorityQueue;
import org.apache.flink.runtime.state.PriorityQueueSetFactory;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimerServiceImpl;
import org.apache.flink.streaming.api.operators.InternalTimerServiceSerializationProxy;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.streaming.api.operators.TimerSerializer;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalTimeServiceManager<K> {
    @VisibleForTesting
    static final String TIMER_STATE_PREFIX = "_timer_state";
    @VisibleForTesting
    static final String PROCESSING_TIMER_PREFIX = "_timer_state/processing_";
    @VisibleForTesting
    static final String EVENT_TIMER_PREFIX = "_timer_state/event_";
    private final KeyGroupRange localKeyGroupRange;
    private final KeyContext keyContext;
    private final PriorityQueueSetFactory priorityQueueSetFactory;
    private final ProcessingTimeService processingTimeService;
    private final Map<String, InternalTimerServiceImpl<K, ?>> timerServices;
    private final boolean useLegacySynchronousSnapshots;

    InternalTimeServiceManager(KeyGroupRange localKeyGroupRange, KeyContext keyContext, PriorityQueueSetFactory priorityQueueSetFactory, ProcessingTimeService processingTimeService, boolean useLegacySynchronousSnapshots) {
        this.localKeyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)localKeyGroupRange);
        this.priorityQueueSetFactory = (PriorityQueueSetFactory)Preconditions.checkNotNull((Object)priorityQueueSetFactory);
        this.keyContext = (KeyContext)Preconditions.checkNotNull((Object)keyContext);
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        this.useLegacySynchronousSnapshots = useLegacySynchronousSnapshots;
        this.timerServices = new HashMap();
    }

    public <N> InternalTimerService<N> getInternalTimerService(String name, TimerSerializer<K, N> timerSerializer, Triggerable<K, N> triggerable) {
        InternalTimerServiceImpl<K, N> timerService = this.registerOrGetTimerService(name, timerSerializer);
        timerService.startTimerService(timerSerializer.getKeySerializer(), timerSerializer.getNamespaceSerializer(), triggerable);
        return timerService;
    }

    <N> InternalTimerServiceImpl<K, N> registerOrGetTimerService(String name, TimerSerializer<K, N> timerSerializer) {
        InternalTimerServiceImpl<K, Object> timerService = this.timerServices.get(name);
        if (timerService == null) {
            timerService = new InternalTimerServiceImpl<K, N>(this.localKeyGroupRange, this.keyContext, this.processingTimeService, this.createTimerPriorityQueue(PROCESSING_TIMER_PREFIX + name, timerSerializer), this.createTimerPriorityQueue(EVENT_TIMER_PREFIX + name, timerSerializer));
            this.timerServices.put(name, timerService);
        }
        return timerService;
    }

    Map<String, InternalTimerServiceImpl<K, ?>> getRegisteredTimerServices() {
        return Collections.unmodifiableMap(this.timerServices);
    }

    private <N> KeyGroupedInternalPriorityQueue<TimerHeapInternalTimer<K, N>> createTimerPriorityQueue(String name, TimerSerializer<K, N> timerSerializer) {
        return this.priorityQueueSetFactory.create(name, timerSerializer);
    }

    public void advanceWatermark(Watermark watermark) throws Exception {
        for (InternalTimerServiceImpl<K, ?> service : this.timerServices.values()) {
            service.advanceWatermark(watermark.getTimestamp());
        }
    }

    public void snapshotStateForKeyGroup(DataOutputView stream, int keyGroupIdx) throws IOException {
        Preconditions.checkState((boolean)this.useLegacySynchronousSnapshots);
        InternalTimerServiceSerializationProxy serializationProxy = new InternalTimerServiceSerializationProxy(this, keyGroupIdx);
        serializationProxy.write(stream);
    }

    public void restoreStateForKeyGroup(InputStream stream, int keyGroupIdx, ClassLoader userCodeClassLoader) throws IOException {
        InternalTimerServiceSerializationProxy serializationProxy = new InternalTimerServiceSerializationProxy(this, userCodeClassLoader, keyGroupIdx);
        serializationProxy.read(stream);
    }

    @VisibleForTesting
    public int numProcessingTimeTimers() {
        int count = 0;
        for (InternalTimerServiceImpl<K, ?> timerService : this.timerServices.values()) {
            count += timerService.numProcessingTimeTimers();
        }
        return count;
    }

    @VisibleForTesting
    public int numEventTimeTimers() {
        int count = 0;
        for (InternalTimerServiceImpl<K, ?> timerService : this.timerServices.values()) {
            count += timerService.numEventTimeTimers();
        }
        return count;
    }
}

