/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CheckpointBarrierAligner
extends CheckpointBarrierHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointBarrierAligner.class);
    private final boolean[] blockedChannels;
    private final int totalNumberOfInputChannels;
    private final String taskName;
    private long currentCheckpointId = -1L;
    private int numBarriersReceived;
    private int numClosedChannels;
    private long startOfAlignmentTimestamp;
    private long latestAlignmentDurationNanos;

    CheckpointBarrierAligner(int totalNumberOfInputChannels, String taskName, @Nullable AbstractInvokable toNotifyOnCheckpoint) {
        super(toNotifyOnCheckpoint);
        this.totalNumberOfInputChannels = totalNumberOfInputChannels;
        this.taskName = taskName;
        this.blockedChannels = new boolean[totalNumberOfInputChannels];
    }

    @Override
    public void releaseBlocksAndResetBarriers() throws IOException {
        LOG.debug("{}: End of stream alignment, feeding buffered data back.", (Object)this.taskName);
        for (int i = 0; i < this.blockedChannels.length; ++i) {
            this.blockedChannels[i] = false;
        }
        this.numBarriersReceived = 0;
        if (this.startOfAlignmentTimestamp > 0L) {
            this.latestAlignmentDurationNanos = System.nanoTime() - this.startOfAlignmentTimestamp;
            this.startOfAlignmentTimestamp = 0L;
        }
    }

    @Override
    public boolean isBlocked(int channelIndex) {
        return this.blockedChannels[channelIndex];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean processBarrier(CheckpointBarrier receivedBarrier, int channelIndex, long bufferedBytes) throws Exception {
        long barrierId = receivedBarrier.getId();
        if (this.totalNumberOfInputChannels == 1) {
            if (barrierId <= this.currentCheckpointId) return false;
            this.currentCheckpointId = barrierId;
            this.notifyCheckpoint(receivedBarrier, bufferedBytes, this.latestAlignmentDurationNanos);
            return false;
        }
        boolean checkpointAborted = false;
        if (this.numBarriersReceived > 0) {
            if (barrierId == this.currentCheckpointId) {
                this.onBarrier(channelIndex);
            } else {
                if (barrierId <= this.currentCheckpointId) return false;
                LOG.warn("{}: Received checkpoint barrier for checkpoint {} before completing current checkpoint {}. Skipping current checkpoint.", new Object[]{this.taskName, barrierId, this.currentCheckpointId});
                this.notifyAbort(this.currentCheckpointId, new CheckpointException("Barrier id: " + barrierId, CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED));
                this.releaseBlocksAndResetBarriers();
                checkpointAborted = true;
                this.beginNewAlignment(barrierId, channelIndex);
            }
        } else {
            if (barrierId <= this.currentCheckpointId) return false;
            this.beginNewAlignment(barrierId, channelIndex);
        }
        if (this.numBarriersReceived + this.numClosedChannels != this.totalNumberOfInputChannels) return checkpointAborted;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Received all barriers, triggering checkpoint {} at {}.", new Object[]{this.taskName, receivedBarrier.getId(), receivedBarrier.getTimestamp()});
        }
        this.releaseBlocksAndResetBarriers();
        this.notifyCheckpoint(receivedBarrier, bufferedBytes, this.latestAlignmentDurationNanos);
        return true;
    }

    protected void beginNewAlignment(long checkpointId, int channelIndex) throws IOException {
        this.currentCheckpointId = checkpointId;
        this.onBarrier(channelIndex);
        this.startOfAlignmentTimestamp = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Starting stream alignment for checkpoint {}.", (Object)this.taskName, (Object)checkpointId);
        }
    }

    protected void onBarrier(int channelIndex) throws IOException {
        if (!this.blockedChannels[channelIndex]) {
            this.blockedChannels[channelIndex] = true;
            ++this.numBarriersReceived;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Received barrier from channel {}.", (Object)this.taskName, (Object)channelIndex);
            }
        } else {
            throw new IOException("Stream corrupt: Repeated barrier for same checkpoint on input " + channelIndex);
        }
    }

    @Override
    public boolean processCancellationBarrier(CancelCheckpointMarker cancelBarrier) throws Exception {
        long barrierId = cancelBarrier.getCheckpointId();
        if (this.totalNumberOfInputChannels == 1) {
            if (barrierId > this.currentCheckpointId) {
                this.currentCheckpointId = barrierId;
                this.notifyAbortOnCancellationBarrier(barrierId);
            }
            return false;
        }
        if (this.numBarriersReceived > 0) {
            if (barrierId == this.currentCheckpointId) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Checkpoint {} canceled, aborting alignment.", (Object)this.taskName, (Object)barrierId);
                }
                this.releaseBlocksAndResetBarriers();
                this.notifyAbortOnCancellationBarrier(barrierId);
                return true;
            }
            if (barrierId > this.currentCheckpointId) {
                LOG.warn("{}: Received cancellation barrier for checkpoint {} before completing current checkpoint {}. Skipping current checkpoint.", new Object[]{this.taskName, barrierId, this.currentCheckpointId});
                this.releaseBlocksAndResetBarriers();
                this.currentCheckpointId = barrierId;
                this.startOfAlignmentTimestamp = 0L;
                this.latestAlignmentDurationNanos = 0L;
                this.notifyAbortOnCancellationBarrier(barrierId);
                return true;
            }
        } else if (barrierId > this.currentCheckpointId) {
            this.currentCheckpointId = barrierId;
            this.startOfAlignmentTimestamp = 0L;
            this.latestAlignmentDurationNanos = 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Checkpoint {} canceled, skipping alignment.", (Object)this.taskName, (Object)barrierId);
            }
            this.notifyAbortOnCancellationBarrier(barrierId);
            return false;
        }
        return false;
    }

    @Override
    public boolean processEndOfPartition() throws Exception {
        ++this.numClosedChannels;
        if (this.numBarriersReceived > 0) {
            this.notifyAbort(this.currentCheckpointId, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_INPUT_END_OF_STREAM));
            this.releaseBlocksAndResetBarriers();
            return true;
        }
        return false;
    }

    @Override
    public long getLatestCheckpointId() {
        return this.currentCheckpointId;
    }

    @Override
    public long getAlignmentDurationNanos() {
        if (this.startOfAlignmentTimestamp <= 0L) {
            return this.latestAlignmentDurationNanos;
        }
        return System.nanoTime() - this.startOfAlignmentTimestamp;
    }

    public String toString() {
        return String.format("%s: last checkpoint: %d, current barriers: %d, closed channels: %d", this.taskName, this.currentCheckpointId, this.numBarriersReceived, this.numClosedChannels);
    }

    @Override
    public void checkpointSizeLimitExceeded(long maxBufferedBytes) throws Exception {
        this.releaseBlocksAndResetBarriers();
        this.notifyAbort(this.currentCheckpointId, new CheckpointException("Max buffered bytes: " + maxBufferedBytes, CheckpointFailureReason.CHECKPOINT_DECLINED_ALIGNMENT_LIMIT_EXCEEDED));
    }
}

