/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.runtime.tasks.CheckpointExceptionHandler;
import org.apache.flink.util.Preconditions;

public class CheckpointExceptionHandlerFactory {
    public CheckpointExceptionHandler createCheckpointExceptionHandler(Environment environment) {
        return new DecliningCheckpointExceptionHandler(environment);
    }

    static final class DecliningCheckpointExceptionHandler
    implements CheckpointExceptionHandler {
        final Environment environment;

        DecliningCheckpointExceptionHandler(Environment environment) {
            this.environment = (Environment)Preconditions.checkNotNull((Object)environment);
        }

        @Override
        public void tryHandleCheckpointException(CheckpointMetaData checkpointMetaData, Exception exception) {
            this.environment.declineCheckpoint(checkpointMetaData.getCheckpointId(), (Throwable)exception);
        }
    }
}

