/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.function.RunnableWithException;

class SynchronousSavepointLatch {
    private static final long NOT_SET_CHECKPOINT_ID = -1L;
    @GuardedBy(value="synchronizationPoint")
    private volatile boolean waiting = false;
    @Nullable
    @GuardedBy(value="synchronizationPoint")
    private volatile CompletionResult completionResult;
    private final Object synchronizationPoint = new Object();
    private volatile long checkpointId = -1L;

    SynchronousSavepointLatch() {
    }

    long getCheckpointId() {
        return this.checkpointId;
    }

    void setCheckpointId(long checkpointId) {
        if (this.checkpointId == -1L) {
            this.checkpointId = checkpointId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockUntilCheckpointIsAcknowledged() throws InterruptedException {
        Object object = this.synchronizationPoint;
        synchronized (object) {
            if (this.isSet()) {
                while (this.completionResult == null) {
                    this.waiting = true;
                    this.synchronizationPoint.wait();
                }
                this.waiting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledgeCheckpointAndTrigger(long checkpointId, RunnableWithException runnable) throws Exception {
        Object object = this.synchronizationPoint;
        synchronized (object) {
            if (this.completionResult == null && this.checkpointId == checkpointId) {
                this.completionResult = CompletionResult.COMPLETED;
                try {
                    runnable.run();
                }
                finally {
                    this.synchronizationPoint.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelCheckpointLatch() {
        Object object = this.synchronizationPoint;
        synchronized (object) {
            if (this.completionResult == null) {
                this.completionResult = CompletionResult.CANCELED;
                this.synchronizationPoint.notifyAll();
            }
        }
    }

    @VisibleForTesting
    boolean isWaiting() {
        return this.waiting;
    }

    @VisibleForTesting
    boolean isCompleted() {
        return this.completionResult == CompletionResult.COMPLETED;
    }

    @VisibleForTesting
    boolean isCanceled() {
        return this.completionResult == CompletionResult.CANCELED;
    }

    boolean isSet() {
        return this.checkpointId != -1L;
    }

    static enum CompletionResult {
        COMPLETED,
        CANCELED;

    }
}

