/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class LookupCallExpression
implements Expression {
    private final String unresolvedName;
    private final List<Expression> args;

    public LookupCallExpression(String unresolvedFunction, List<Expression> args) {
        this.unresolvedName = (String)Preconditions.checkNotNull((Object)unresolvedFunction);
        this.args = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(args)));
    }

    public String getUnresolvedName() {
        return this.unresolvedName;
    }

    public String asSummaryString() {
        List argList = this.args.stream().map(Object::toString).collect(Collectors.toList());
        return this.unresolvedName + "(" + String.join((CharSequence)", ", argList) + ")";
    }

    public List<Expression> getChildren() {
        return this.args;
    }

    public <R> R accept(ExpressionVisitor<R> visitor) {
        return (R)visitor.visit((Expression)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupCallExpression that = (LookupCallExpression)o;
        return Objects.equals(this.unresolvedName, that.unresolvedName) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.unresolvedName, this.args);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

