/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.util.StringUtils;

@Internal
public class OperationUtils {
    private static final String OPERATION_INDENT = "    ";

    static String indent(String item) {
        return "\n    " + item.replace("\n    ", "\n        ");
    }

    public static <T extends Operation> String formatWithChildren(String operationName, Map<String, Object> parameters, List<T> children, Function<T, String> childToString) {
        String description = parameters.entrySet().stream().map(entry -> OperationUtils.formatParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(operationName).append(":");
        if (!StringUtils.isNullOrWhitespaceOnly((String)description)) {
            stringBuilder.append(" (").append(description).append(")");
        }
        String childrenDescription = children.stream().map(child -> OperationUtils.indent((String)childToString.apply(child))).collect(Collectors.joining());
        return stringBuilder.append(childrenDescription).toString();
    }

    private static String formatParameter(String name, Object value) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(name);
        stringBuilder.append(": ");
        if (value.getClass().isArray()) {
            stringBuilder.append(Arrays.toString((Object[])value));
        } else if (value instanceof Collection) {
            stringBuilder.append(value);
        } else {
            stringBuilder.append("[").append(value).append("]");
        }
        return stringBuilder.toString();
    }

    private OperationUtils() {
    }
}

