/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

public class FieldInfoUtils {
    private static final String ATOMIC_FIELD_NAME = "f0";

    public static boolean isReferenceByPosition(CompositeType<?> ct, Expression[] fields) {
        if (!(ct instanceof TupleTypeInfoBase)) {
            return false;
        }
        List<String> inputNames = Arrays.asList(ct.getFieldNames());
        return Arrays.stream(fields).allMatch(f -> {
            if (f instanceof UnresolvedReferenceExpression) {
                return !inputNames.contains(((UnresolvedReferenceExpression)f).getName());
            }
            return true;
        });
    }

    public static <A> TypeInfoSchema getFieldsInfo(TypeInformation<A> inputType) {
        if (inputType instanceof GenericTypeInfo && inputType.getTypeClass() == Row.class) {
            throw new ValidationException("An input of GenericTypeInfo<Row> cannot be converted to Table. Please specify the type of the input with a RowTypeInfo.");
        }
        return new TypeInfoSchema(FieldInfoUtils.getFieldNames(inputType), FieldInfoUtils.getFieldIndices(inputType), TypeConversions.fromLegacyInfoToDataType(FieldInfoUtils.getFieldTypes(inputType)), false);
    }

    public static <A> TypeInfoSchema getFieldsInfo(TypeInformation<A> inputType, Expression[] expressions) {
        FieldInfoUtils.validateInputTypeInfo(inputType);
        List<FieldInfo> fieldInfos = FieldInfoUtils.extractFieldInformation(inputType, expressions);
        FieldInfoUtils.validateNoStarReference(fieldInfos);
        boolean isRowtimeAttribute = FieldInfoUtils.checkIfRowtimeAttribute(fieldInfos);
        FieldInfoUtils.validateAtMostOneProctimeAttribute(fieldInfos);
        String[] fieldNames = (String[])fieldInfos.stream().map(FieldInfo::getFieldName).toArray(String[]::new);
        int[] fieldIndices = fieldInfos.stream().mapToInt(FieldInfo::getIndex).toArray();
        DataType[] dataTypes = (DataType[])fieldInfos.stream().map(FieldInfo::getType).toArray(DataType[]::new);
        return new TypeInfoSchema(fieldNames, fieldIndices, dataTypes, isRowtimeAttribute);
    }

    private static void validateNoStarReference(List<FieldInfo> fieldInfos) {
        if (fieldInfos.stream().anyMatch(info -> info.getFieldName().equals("*"))) {
            throw new ValidationException("Field name can not be '*'.");
        }
    }

    private static <A> List<FieldInfo> extractFieldInformation(TypeInformation<A> inputType, Expression[] exprs) {
        if (inputType instanceof GenericTypeInfo && inputType.getTypeClass() == Row.class) {
            throw new ValidationException("An input of GenericTypeInfo<Row> cannot be converted to Table. Please specify the type of the input with a RowTypeInfo.");
        }
        List<FieldInfo> fieldInfos = inputType instanceof TupleTypeInfoBase ? FieldInfoUtils.extractFieldInfosFromTupleType((TupleTypeInfoBase)inputType, exprs) : (inputType instanceof PojoTypeInfo ? FieldInfoUtils.extractFieldInfosByNameReference((CompositeType)inputType, exprs) : FieldInfoUtils.extractFieldInfoFromAtomicType(inputType, exprs));
        return fieldInfos;
    }

    private static void validateAtMostOneProctimeAttribute(List<FieldInfo> fieldInfos) {
        List proctimeAttributes = fieldInfos.stream().filter(FieldInfoUtils::isProctimeField).collect(Collectors.toList());
        if (proctimeAttributes.size() > 1) {
            throw new ValidationException("The proctime attribute can only be defined once in a table schema. Duplicated proctime attributes: " + proctimeAttributes);
        }
    }

    private static boolean checkIfRowtimeAttribute(List<FieldInfo> fieldInfos) {
        List rowtimeAttributes = fieldInfos.stream().filter(FieldInfoUtils::isRowtimeField).collect(Collectors.toList());
        if (rowtimeAttributes.size() > 1) {
            throw new ValidationException("The rowtime attribute can only be defined once in a table schema. Duplicated rowtime attributes: " + rowtimeAttributes);
        }
        return rowtimeAttributes.size() > 0;
    }

    public static <A> String[] getFieldNames(TypeInformation<A> inputType) {
        return FieldInfoUtils.getFieldNames(inputType, Collections.emptyList());
    }

    public static <A> String[] getFieldNames(TypeInformation<A> inputType, List<String> existingNames) {
        String[] fieldNames;
        FieldInfoUtils.validateInputTypeInfo(inputType);
        if (inputType instanceof CompositeType) {
            fieldNames = ((CompositeType)inputType).getFieldNames();
        } else {
            int i = 0;
            String fieldName = ATOMIC_FIELD_NAME;
            while (null != existingNames && existingNames.contains(fieldName)) {
                fieldName = "f0_" + i++;
            }
            fieldNames = new String[]{fieldName};
        }
        if (Arrays.asList(fieldNames).contains("*")) {
            throw new TableException("Field name can not be '*'.");
        }
        return fieldNames;
    }

    public static <A> void validateInputTypeInfo(TypeInformation<A> typeInfo) {
        Class clazz = typeInfo.getTypeClass();
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers()) || clazz.getCanonicalName() == null) {
            throw new ValidationException(String.format("Class '%s' described in type information '%s' must be static and globally accessible.", clazz, typeInfo));
        }
    }

    public static int[] getFieldIndices(TypeInformation<?> inputType) {
        return IntStream.range(0, FieldInfoUtils.getFieldNames(inputType).length).toArray();
    }

    public static TypeInformation<?>[] getFieldTypes(TypeInformation<?> inputType) {
        TypeInformation[] fieldTypes;
        FieldInfoUtils.validateInputTypeInfo(inputType);
        if (inputType instanceof CompositeType) {
            int arity = inputType.getArity();
            CompositeType ct = (CompositeType)inputType;
            fieldTypes = (TypeInformation[])IntStream.range(0, arity).mapToObj(arg_0 -> ((CompositeType)ct).getTypeAt(arg_0)).toArray(TypeInformation[]::new);
        } else {
            fieldTypes = new TypeInformation[]{inputType};
        }
        return fieldTypes;
    }

    private static List<FieldInfo> extractFieldInfoFromAtomicType(TypeInformation<?> atomicType, Expression[] exprs) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>(exprs.length);
        boolean alreadyReferenced = false;
        for (int i = 0; i < exprs.length; ++i) {
            UnresolvedReferenceExpression reference;
            Expression expr = exprs[i];
            if (expr instanceof UnresolvedReferenceExpression) {
                if (alreadyReferenced) {
                    throw new ValidationException("Too many fields referenced from an atomic type.");
                }
                alreadyReferenced = true;
                String name = ((UnresolvedReferenceExpression)expr).getName();
                fields.add(new FieldInfo(name, i, TypeConversions.fromLegacyInfoToDataType(atomicType)));
                continue;
            }
            if (FieldInfoUtils.isRowTimeExpression(expr)) {
                reference = FieldInfoUtils.getChildAsReference(expr);
                fields.add(FieldInfoUtils.createTimeAttributeField(reference, TimestampKind.ROWTIME, null));
                continue;
            }
            if (FieldInfoUtils.isProcTimeExpression(expr)) {
                reference = FieldInfoUtils.getChildAsReference(expr);
                fields.add(FieldInfoUtils.createTimeAttributeField(reference, TimestampKind.PROCTIME, null));
                continue;
            }
            throw new ValidationException("Field reference expression expected.");
        }
        return fields;
    }

    private static List<FieldInfo> extractFieldInfosFromTupleType(TupleTypeInfoBase<?> inputType, Expression[] exprs) {
        boolean isRefByPos = FieldInfoUtils.isReferenceByPosition(inputType, exprs);
        if (isRefByPos) {
            return IntStream.range(0, exprs.length).mapToObj(idx -> (FieldInfo)exprs[idx].accept((ExpressionVisitor)new IndexedExprToFieldInfo((CompositeType)inputType, idx))).collect(Collectors.toList());
        }
        return FieldInfoUtils.extractFieldInfosByNameReference(inputType, exprs);
    }

    private static List<FieldInfo> extractFieldInfosByNameReference(CompositeType<?> inputType, Expression[] exprs) {
        ExprToFieldInfo exprToFieldInfo = new ExprToFieldInfo(inputType);
        return Arrays.stream(exprs).map(expr -> (FieldInfo)expr.accept((ExpressionVisitor)exprToFieldInfo)).collect(Collectors.toList());
    }

    private static String extractAlias(Expression aliasExpr) {
        return (String)ExpressionUtils.extractValue((Expression)aliasExpr, String.class).orElseThrow(() -> new TableException("Alias expects string literal as new name. Got: " + aliasExpr));
    }

    private static void checkRowtimeType(TypeInformation<?> type) {
        if (!type.equals((Object)Types.LONG()) && !(type instanceof SqlTimeTypeInfo)) {
            throw new ValidationException("The rowtime attribute can only replace a field with a valid time type, such as Timestamp or Long. But was: " + type);
        }
    }

    private static boolean isRowtimeField(FieldInfo field) {
        DataType type = field.getType();
        return LogicalTypeChecks.hasRoot((LogicalType)type.getLogicalType(), (LogicalTypeRoot)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && LogicalTypeChecks.isRowtimeAttribute((LogicalType)type.getLogicalType());
    }

    private static boolean isProctimeField(FieldInfo field) {
        DataType type = field.getType();
        return LogicalTypeChecks.hasRoot((LogicalType)type.getLogicalType(), (LogicalTypeRoot)LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && LogicalTypeChecks.isProctimeAttribute((LogicalType)type.getLogicalType());
    }

    private static boolean isRowTimeExpression(Expression origExpr) {
        return origExpr instanceof UnresolvedCallExpression && ((UnresolvedCallExpression)origExpr).getFunctionDefinition() == BuiltInFunctionDefinitions.ROWTIME;
    }

    private static boolean isProcTimeExpression(Expression origExpr) {
        return origExpr instanceof UnresolvedCallExpression && ((UnresolvedCallExpression)origExpr).getFunctionDefinition() == BuiltInFunctionDefinitions.PROCTIME;
    }

    private static Optional<Integer> referenceByName(String name, CompositeType<?> ct) {
        int inputIdx = ct.getFieldIndex(name);
        if (inputIdx < 0) {
            return Optional.empty();
        }
        return Optional.of(inputIdx);
    }

    private static <T> Set<T> findDuplicates(T[] array) {
        HashSet<T> duplicates = new HashSet<T>();
        HashSet<T> seenElements = new HashSet<T>();
        for (T t : array) {
            if (seenElements.contains(t)) {
                duplicates.add(t);
                continue;
            }
            seenElements.add(t);
        }
        return duplicates;
    }

    private static FieldInfo createTimeAttributeField(UnresolvedReferenceExpression reference, TimestampKind kind, @Nullable String alias) {
        int idx = kind == TimestampKind.PROCTIME ? -2 : -1;
        String originalName = reference.getName();
        return new FieldInfo(alias != null ? alias : originalName, idx, FieldInfoUtils.createTimeIndicatorType(kind));
    }

    private static UnresolvedReferenceExpression getChildAsReference(Expression expression) {
        Expression child = (Expression)expression.getChildren().get(0);
        if (child instanceof UnresolvedReferenceExpression) {
            return (UnresolvedReferenceExpression)child;
        }
        throw new ValidationException("Field reference expression expected.");
    }

    private static DataType createTimeIndicatorType(TimestampKind kind) {
        return new AtomicDataType((LogicalType)new TimestampType(true, kind, 3)).bridgedTo(Timestamp.class);
    }

    private FieldInfoUtils() {
    }

    private static class ExprToFieldInfo
    extends ApiExpressionDefaultVisitor<FieldInfo> {
        private final CompositeType ct;

        private ExprToFieldInfo(CompositeType ct) {
            this.ct = ct;
        }

        private ValidationException fieldNotFound(String name) {
            return new ValidationException(String.format("%s is not a field of type %s. Expected: %s}", name, this.ct, String.join((CharSequence)", ", this.ct.getFieldNames())));
        }

        @Override
        public FieldInfo visit(UnresolvedReferenceExpression unresolvedReference) {
            return this.createFieldInfo(unresolvedReference, null);
        }

        @Override
        public FieldInfo visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                return this.visitAlias(unresolvedCall);
            }
            if (FieldInfoUtils.isRowTimeExpression(unresolvedCall)) {
                return this.createRowtimeFieldInfo(unresolvedCall, null);
            }
            if (FieldInfoUtils.isProcTimeExpression(unresolvedCall)) {
                return this.createProctimeFieldInfo(unresolvedCall, null);
            }
            return this.defaultMethod(unresolvedCall);
        }

        private FieldInfo visitAlias(UnresolvedCallExpression unresolvedCall) {
            List<Expression> children = unresolvedCall.getChildren();
            String newName = FieldInfoUtils.extractAlias(children.get(1));
            Expression child = children.get(0);
            if (child instanceof UnresolvedReferenceExpression) {
                return this.createFieldInfo((UnresolvedReferenceExpression)child, newName);
            }
            if (FieldInfoUtils.isRowTimeExpression(child)) {
                return this.createRowtimeFieldInfo(child, newName);
            }
            if (FieldInfoUtils.isProcTimeExpression(child)) {
                return this.createProctimeFieldInfo(child, newName);
            }
            return this.defaultMethod(unresolvedCall);
        }

        private FieldInfo createFieldInfo(UnresolvedReferenceExpression unresolvedReference, @Nullable String alias) {
            String fieldName = unresolvedReference.getName();
            return FieldInfoUtils.referenceByName(fieldName, this.ct).map(idx -> new FieldInfo(alias != null ? alias : fieldName, (int)idx, TypeConversions.fromLegacyInfoToDataType((TypeInformation)this.ct.getTypeAt(idx.intValue())))).orElseThrow(() -> this.fieldNotFound(fieldName));
        }

        private FieldInfo createProctimeFieldInfo(Expression expression, @Nullable String alias) {
            UnresolvedReferenceExpression reference = FieldInfoUtils.getChildAsReference(expression);
            String originalName = reference.getName();
            this.validateProctimeDoesNotReplaceField(originalName);
            return FieldInfoUtils.createTimeAttributeField(reference, TimestampKind.PROCTIME, alias);
        }

        private void validateProctimeDoesNotReplaceField(String originalName) {
            if (FieldInfoUtils.referenceByName(originalName, this.ct).isPresent()) {
                throw new ValidationException(String.format("The proctime attribute '%s' must not replace an existing field.", originalName));
            }
        }

        private FieldInfo createRowtimeFieldInfo(Expression expression, @Nullable String alias) {
            UnresolvedReferenceExpression reference = FieldInfoUtils.getChildAsReference(expression);
            String originalName = reference.getName();
            this.verifyReferencesValidField(originalName, alias);
            return FieldInfoUtils.createTimeAttributeField(reference, TimestampKind.ROWTIME, alias);
        }

        private void verifyReferencesValidField(String origName, @Nullable String alias) {
            Optional refId = FieldInfoUtils.referenceByName(origName, this.ct);
            if (refId.isPresent()) {
                FieldInfoUtils.checkRowtimeType(this.ct.getTypeAt(((Integer)refId.get()).intValue()));
            } else if (alias != null) {
                throw new ValidationException(String.format("Alias '%s' must reference an existing field.", alias));
            }
        }

        @Override
        protected FieldInfo defaultMethod(Expression expression) {
            throw new ValidationException("Field reference expression or alias on field expression expected.");
        }
    }

    private static class IndexedExprToFieldInfo
    extends ApiExpressionDefaultVisitor<FieldInfo> {
        private final CompositeType<?> inputType;
        private final int index;

        private IndexedExprToFieldInfo(CompositeType<?> inputType, int index) {
            this.inputType = inputType;
            this.index = index;
        }

        @Override
        public FieldInfo visit(UnresolvedReferenceExpression unresolvedReference) {
            String fieldName = unresolvedReference.getName();
            return new FieldInfo(fieldName, this.index, TypeConversions.fromLegacyInfoToDataType(this.getTypeAt(unresolvedReference)));
        }

        @Override
        public FieldInfo visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                return this.visitAlias(unresolvedCall);
            }
            if (FieldInfoUtils.isRowTimeExpression(unresolvedCall)) {
                this.validateRowtimeReplacesCompatibleType(unresolvedCall);
                return FieldInfoUtils.createTimeAttributeField(FieldInfoUtils.getChildAsReference(unresolvedCall), TimestampKind.ROWTIME, null);
            }
            if (FieldInfoUtils.isProcTimeExpression(unresolvedCall)) {
                this.validateProcTimeAttributeAppended(unresolvedCall);
                return FieldInfoUtils.createTimeAttributeField(FieldInfoUtils.getChildAsReference(unresolvedCall), TimestampKind.PROCTIME, null);
            }
            return this.defaultMethod(unresolvedCall);
        }

        private FieldInfo visitAlias(UnresolvedCallExpression unresolvedCall) {
            List<Expression> children = unresolvedCall.getChildren();
            String newName = FieldInfoUtils.extractAlias(children.get(1));
            Expression child = children.get(0);
            if (FieldInfoUtils.isProcTimeExpression(child)) {
                this.validateProcTimeAttributeAppended(unresolvedCall);
                return FieldInfoUtils.createTimeAttributeField(FieldInfoUtils.getChildAsReference(child), TimestampKind.PROCTIME, newName);
            }
            throw new ValidationException(String.format("Alias '%s' is not allowed if other fields are referenced by position.", newName));
        }

        private void validateRowtimeReplacesCompatibleType(UnresolvedCallExpression unresolvedCall) {
            if (this.index < this.inputType.getArity()) {
                FieldInfoUtils.checkRowtimeType(this.getTypeAt(unresolvedCall));
            }
        }

        private void validateProcTimeAttributeAppended(UnresolvedCallExpression unresolvedCall) {
            if (this.index < this.inputType.getArity()) {
                throw new ValidationException(String.format("The proctime attribute can only be appended to the table schema and not replace an existing field. Please move '%s' to the end of the schema.", unresolvedCall));
            }
        }

        private TypeInformation<Object> getTypeAt(Expression expr) {
            if (this.index >= this.inputType.getArity()) {
                throw new ValidationException(String.format("Number of expressions does not match number of input fields.\nAvailable fields: %s\nCould not map: %s", Arrays.toString(this.inputType.getFieldNames()), expr));
            }
            return this.inputType.getTypeAt(this.index);
        }

        @Override
        protected FieldInfo defaultMethod(Expression expression) {
            throw new ValidationException("Field reference expression or alias on field expression expected.");
        }
    }

    private static class FieldInfo {
        private final String fieldName;
        private final int index;
        private final DataType type;

        FieldInfo(String fieldName, int index, DataType type) {
            this.fieldName = fieldName;
            this.index = index;
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getIndex() {
            return this.index;
        }

        public DataType getType() {
            return this.type;
        }
    }

    public static class TypeInfoSchema {
        private final String[] fieldNames;
        private final int[] indices;
        private final DataType[] fieldTypes;
        private final boolean isRowtimeDefined;

        TypeInfoSchema(String[] fieldNames, int[] indices, DataType[] fieldTypes, boolean isRowtimeDefined) {
            this.validateEqualLength(fieldNames, indices, fieldTypes);
            this.validateNamesUniqueness(fieldNames);
            this.isRowtimeDefined = isRowtimeDefined;
            this.fieldNames = fieldNames;
            this.indices = indices;
            this.fieldTypes = fieldTypes;
        }

        private void validateEqualLength(String[] fieldNames, int[] indices, DataType[] fieldTypes) {
            if (fieldNames.length != indices.length || indices.length != fieldTypes.length) {
                throw new TableException(String.format("Mismatched number of indices, names and types:\nNames: %s\nIndices: %s\nTypes: %s", Arrays.toString(fieldNames), Arrays.toString(indices), Arrays.toString(fieldTypes)));
            }
        }

        private void validateNamesUniqueness(String[] fieldNames) {
            Set duplicatedNames = FieldInfoUtils.findDuplicates(fieldNames);
            if (duplicatedNames.size() != 0) {
                throw new ValidationException(String.format("Field names must be unique.\nList of duplicate fields: [%s].\nList of all fields: [%s].", String.join((CharSequence)", ", duplicatedNames), String.join((CharSequence)", ", fieldNames)));
            }
        }

        public String[] getFieldNames() {
            return this.fieldNames;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public DataType[] getFieldTypes() {
            return this.fieldTypes;
        }

        public boolean isRowtimeDefined() {
            return this.isRowtimeDefined;
        }

        public TableSchema toTableSchema() {
            return TableSchema.builder().fields(this.fieldNames, this.fieldTypes).build();
        }
    }
}

