/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public class TableSchema {
    private static final String ATOMIC_TYPE_FIELD_NAME = "f0";
    private final List<TableColumn> columns;
    private final List<WatermarkSpec> watermarkSpecs;
    @Nullable
    private final UniqueConstraint primaryKey;

    private TableSchema(List<TableColumn> columns, List<WatermarkSpec> watermarkSpecs, @Nullable UniqueConstraint primaryKey) {
        this.columns = (List)Preconditions.checkNotNull(columns);
        this.watermarkSpecs = (List)Preconditions.checkNotNull(watermarkSpecs);
        this.primaryKey = primaryKey;
    }

    @Deprecated
    public TableSchema(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        DataType[] fieldDataTypes = TypeConversions.fromLegacyInfoToDataType(fieldTypes);
        TableSchema.validateNameTypeNumberEqual(fieldNames, fieldDataTypes);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (int i = 0; i < fieldNames.length; ++i) {
            columns.add(TableColumn.physical(fieldNames[i], fieldDataTypes[i]));
        }
        TableSchema.validateColumnsAndWatermarkSpecs(columns, Collections.emptyList());
        this.columns = columns;
        this.watermarkSpecs = Collections.emptyList();
        this.primaryKey = null;
    }

    public TableSchema copy() {
        return new TableSchema(new ArrayList<TableColumn>(this.columns), new ArrayList<WatermarkSpec>(this.watermarkSpecs), this.primaryKey);
    }

    public DataType[] getFieldDataTypes() {
        return (DataType[])this.columns.stream().map(TableColumn::getType).toArray(DataType[]::new);
    }

    @Deprecated
    public TypeInformation<?>[] getFieldTypes() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.getFieldDataTypes());
    }

    public Optional<DataType> getFieldDataType(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.columns.size()) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(fieldIndex).getType());
    }

    @Deprecated
    public Optional<TypeInformation<?>> getFieldType(int fieldIndex) {
        return this.getFieldDataType(fieldIndex).map(TypeConversions::fromDataTypeToLegacyInfo);
    }

    public Optional<DataType> getFieldDataType(String fieldName) {
        return this.columns.stream().filter(column -> column.getName().equals(fieldName)).findFirst().map(TableColumn::getType);
    }

    @Deprecated
    public Optional<TypeInformation<?>> getFieldType(String fieldName) {
        return this.getFieldDataType(fieldName).map(TypeConversions::fromDataTypeToLegacyInfo);
    }

    public int getFieldCount() {
        return this.columns.size();
    }

    public String[] getFieldNames() {
        return (String[])this.columns.stream().map(TableColumn::getName).toArray(String[]::new);
    }

    public Optional<String> getFieldName(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.columns.size()) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(fieldIndex).getName());
    }

    public Optional<TableColumn> getTableColumn(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.columns.size()) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(fieldIndex));
    }

    public Optional<TableColumn> getTableColumn(String fieldName) {
        return this.columns.stream().filter(column -> column.getName().equals(fieldName)).findFirst();
    }

    public List<TableColumn> getTableColumns() {
        return new ArrayList<TableColumn>(this.columns);
    }

    public DataType toRowDataType() {
        DataTypes.Field[] fields = (DataTypes.Field[])this.columns.stream().map(column -> DataTypes.FIELD(column.getName(), column.getType())).toArray(DataTypes.Field[]::new);
        return (DataType)DataTypes.ROW(fields).notNull();
    }

    public DataType toPhysicalRowDataType() {
        DataTypes.Field[] fields = (DataTypes.Field[])this.columns.stream().filter(TableColumn::isPhysical).map(column -> DataTypes.FIELD(column.getName(), column.getType())).toArray(DataTypes.Field[]::new);
        return (DataType)DataTypes.ROW(fields).notNull();
    }

    public DataType toPersistedRowDataType() {
        DataTypes.Field[] fields = (DataTypes.Field[])this.columns.stream().filter(TableColumn::isPersisted).map(column -> DataTypes.FIELD(column.getName(), column.getType())).toArray(DataTypes.Field[]::new);
        return (DataType)DataTypes.ROW(fields).notNull();
    }

    @Deprecated
    public TypeInformation<Row> toRowType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.toRowDataType());
    }

    public List<WatermarkSpec> getWatermarkSpecs() {
        return this.watermarkSpecs;
    }

    public Optional<UniqueConstraint> getPrimaryKey() {
        return Optional.ofNullable(this.primaryKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("root\n");
        for (TableColumn column : this.columns) {
            sb.append(" |-- ");
            sb.append(column.asSummaryString());
            sb.append('\n');
        }
        if (!this.watermarkSpecs.isEmpty()) {
            for (WatermarkSpec watermarkSpec : this.watermarkSpecs) {
                sb.append(" |-- ");
                sb.append(watermarkSpec.asSummaryString());
                sb.append('\n');
            }
        }
        if (this.primaryKey != null) {
            sb.append(" |-- ").append(this.primaryKey.asSummaryString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema that = (TableSchema)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.watermarkSpecs, that.watermarkSpecs) && Objects.equals(this.primaryKey, that.primaryKey);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.watermarkSpecs, this.primaryKey);
    }

    @Deprecated
    public static TableSchema fromTypeInfo(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)typeInfo;
            String[] fieldNames = compositeType.getFieldNames();
            TypeInformation[] fieldTypes = new TypeInformation[fieldNames.length];
            for (int i = 0; i < fieldTypes.length; ++i) {
                fieldTypes[i] = compositeType.getTypeAt(i);
            }
            return new TableSchema(fieldNames, fieldTypes);
        }
        return new TableSchema(new String[]{ATOMIC_TYPE_FIELD_NAME}, new TypeInformation[]{typeInfo});
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void validateNameTypeNumberEqual(String[] fieldNames, DataType[] fieldTypes) {
        if (fieldNames.length != fieldTypes.length) {
            throw new ValidationException("Number of field names and field data types must be equal.\nNumber of names is " + fieldNames.length + ", number of data types is " + fieldTypes.length + ".\nList of field names: " + Arrays.toString(fieldNames) + "\nList of field data types: " + Arrays.toString(fieldTypes));
        }
    }

    private static void validateColumnsAndWatermarkSpecs(List<TableColumn> columns, List<WatermarkSpec> watermarkSpecs) {
        HashMap<String, LogicalType> fieldNameToType = new HashMap<String, LogicalType>();
        for (TableColumn column : columns) {
            TableSchema.validateAndCreateNameToTypeMapping(fieldNameToType, column.getName(), column.getType().getLogicalType(), "");
        }
        for (WatermarkSpec watermark : watermarkSpecs) {
            String rowtimeAttribute = watermark.getRowtimeAttribute();
            LogicalType rowtimeType = (LogicalType)Optional.ofNullable(fieldNameToType.get(rowtimeAttribute)).orElseThrow(() -> new ValidationException(String.format("Rowtime attribute '%s' is not defined in schema.", rowtimeAttribute)));
            if (rowtimeType.getTypeRoot() != LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
                throw new ValidationException(String.format("Rowtime attribute '%s' must be of type TIMESTAMP but is of type '%s'.", rowtimeAttribute, rowtimeType));
            }
            LogicalType watermarkOutputType = watermark.getWatermarkExprOutputType().getLogicalType();
            if (watermarkOutputType.getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) continue;
            throw new ValidationException(String.format("Watermark strategy %s must be of type TIMESTAMP but is of type '%s'.", watermark.getWatermarkExpr(), watermarkOutputType.asSummaryString()));
        }
    }

    private static void validatePrimaryKey(List<TableColumn> columns, UniqueConstraint primaryKey) {
        Map columnsByNameLookup = columns.stream().collect(Collectors.toMap(TableColumn::getName, Function.identity()));
        for (String columnName : primaryKey.getColumns()) {
            TableColumn column = (TableColumn)columnsByNameLookup.get(columnName);
            if (column == null) {
                throw new ValidationException(String.format("Could not create a PRIMARY KEY '%s'. Column '%s' does not exist.", primaryKey.getName(), columnName));
            }
            if (!column.isPhysical()) {
                throw new ValidationException(String.format("Could not create a PRIMARY KEY '%s'. Column '%s' is not a physical column.", primaryKey.getName(), columnName));
            }
            if (!column.getType().getLogicalType().isNullable()) continue;
            throw new ValidationException(String.format("Could not create a PRIMARY KEY '%s'. Column '%s' is nullable.", primaryKey.getName(), columnName));
        }
    }

    private static void validateAndCreateNameToTypeMapping(Map<String, LogicalType> fieldNameToType, String fieldName, LogicalType fieldType, String parentFieldName) {
        String fullFieldName = parentFieldName.isEmpty() ? fieldName : parentFieldName + "." + fieldName;
        LogicalType oldType = fieldNameToType.put(fullFieldName, fieldType);
        if (oldType != null) {
            throw new ValidationException("Field names must be unique. Duplicate field: '" + fullFieldName + "'");
        }
        if (LogicalTypeChecks.isCompositeType(fieldType) && !(fieldType instanceof LegacyTypeInformationType)) {
            List<String> fieldNames = LogicalTypeChecks.getFieldNames(fieldType);
            List<LogicalType> fieldTypes = fieldType.getChildren();
            IntStream.range(0, fieldNames.size()).forEach(i -> TableSchema.validateAndCreateNameToTypeMapping(fieldNameToType, (String)fieldNames.get(i), (LogicalType)fieldTypes.get(i), fullFieldName));
        }
    }

    public static class Builder {
        private List<TableColumn> columns = new ArrayList<TableColumn>();
        private final List<WatermarkSpec> watermarkSpecs = new ArrayList<WatermarkSpec>();
        private UniqueConstraint primaryKey;

        public Builder field(String name, DataType dataType) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)dataType);
            this.columns.add(TableColumn.physical(name, dataType));
            return this;
        }

        public Builder field(String name, DataType dataType, String expression) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)dataType);
            Preconditions.checkNotNull((Object)expression);
            this.columns.add(TableColumn.computed(name, dataType, expression));
            return this;
        }

        public Builder add(TableColumn column) {
            this.columns.add(column);
            return this;
        }

        public Builder fields(String[] names, DataType[] dataTypes) {
            Preconditions.checkNotNull((Object)names);
            Preconditions.checkNotNull((Object)dataTypes);
            TableSchema.validateNameTypeNumberEqual(names, dataTypes);
            List columns = IntStream.range(0, names.length).mapToObj(idx -> TableColumn.physical(names[idx], dataTypes[idx])).collect(Collectors.toList());
            this.columns.addAll(columns);
            return this;
        }

        @Deprecated
        public Builder field(String name, TypeInformation<?> typeInfo) {
            return this.field(name, TypeConversions.fromLegacyInfoToDataType(typeInfo));
        }

        public Builder watermark(String rowtimeAttribute, String watermarkExpressionString, DataType watermarkExprOutputType) {
            Preconditions.checkNotNull((Object)rowtimeAttribute);
            Preconditions.checkNotNull((Object)watermarkExpressionString);
            Preconditions.checkNotNull((Object)watermarkExprOutputType);
            if (!this.watermarkSpecs.isEmpty()) {
                throw new IllegalStateException("Multiple watermark definition is not supported yet.");
            }
            this.watermarkSpecs.add(new WatermarkSpec(rowtimeAttribute, watermarkExpressionString, watermarkExprOutputType));
            return this;
        }

        public Builder watermark(WatermarkSpec watermarkSpec) {
            if (!this.watermarkSpecs.isEmpty()) {
                throw new IllegalStateException("Multiple watermark definition is not supported yet.");
            }
            this.watermarkSpecs.add(watermarkSpec);
            return this;
        }

        public Builder primaryKey(String ... columns) {
            return this.primaryKey(UUID.randomUUID().toString(), columns);
        }

        public Builder primaryKey(String name, String[] columns) {
            if (this.primaryKey != null) {
                throw new ValidationException("Can not create multiple PRIMARY keys.");
            }
            if (StringUtils.isNullOrWhitespaceOnly((String)name)) {
                throw new ValidationException("PRIMARY KEY's name can not be null or empty.");
            }
            if (columns == null || columns.length == 0) {
                throw new ValidationException("PRIMARY KEY constraint must be defined for at least a single column.");
            }
            this.primaryKey = UniqueConstraint.primaryKey(name, Arrays.asList(columns));
            return this;
        }

        public TableSchema build() {
            TableSchema.validateColumnsAndWatermarkSpecs(this.columns, this.watermarkSpecs);
            if (this.primaryKey != null) {
                TableSchema.validatePrimaryKey(this.columns, this.primaryKey);
            }
            return new TableSchema(this.columns, this.watermarkSpecs, this.primaryKey);
        }
    }
}

