/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.descriptors.DescriptorBase;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public abstract class CatalogDescriptor
extends DescriptorBase {
    private final String type;
    private final int propertyVersion;
    private final String defaultDatabase;

    public CatalogDescriptor(String type, int propertyVersion) {
        this(type, propertyVersion, null);
    }

    public CatalogDescriptor(String type, int propertyVersion, String defaultDatabase) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        this.type = type;
        this.propertyVersion = propertyVersion;
        this.defaultDatabase = defaultDatabase;
    }

    @Override
    public final Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putString("type", this.type);
        properties.putLong("property-version", this.propertyVersion);
        if (this.defaultDatabase != null) {
            properties.putString("default-database", this.defaultDatabase);
        }
        properties.putProperties(this.toCatalogProperties());
        return properties.asMap();
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    protected abstract Map<String, String> toCatalogProperties();
}

