/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.TimestampKind;

@PublicEvolving
public final class TimestampType
extends LogicalType {
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 6;
    private static final String FORMAT = "TIMESTAMP(%d)";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = TimestampType.conversionSet(Timestamp.class.getName(), LocalDateTime.class.getName(), TimestampData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = LocalDateTime.class;
    private final TimestampKind kind;
    private final int precision;

    @Internal
    public TimestampType(boolean isNullable, TimestampKind kind, int precision) {
        super(isNullable, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE);
        if (precision < 0 || precision > 9) {
            throw new ValidationException(String.format("Timestamp precision must be between %d and %d (both inclusive).", 0, 9));
        }
        this.kind = kind;
        this.precision = precision;
    }

    public TimestampType(boolean isNullable, int precision) {
        this(isNullable, TimestampKind.REGULAR, precision);
    }

    public TimestampType(int precision) {
        this(true, precision);
    }

    public TimestampType() {
        this(6);
    }

    @Internal
    public TimestampKind getKind() {
        return this.kind;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new TimestampType(isNullable, this.kind, this.precision);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.precision);
    }

    @Override
    public String asSummaryString() {
        if (this.kind != TimestampKind.REGULAR) {
            return String.format("%s *%s*", new Object[]{this.asSerializableString(), this.kind});
        }
        return this.asSerializableString();
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimestampType that = (TimestampType)o;
        return this.precision == that.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }
}

