/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.CommonTypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExplicitTypeStrategy;
import org.apache.flink.table.types.inference.strategies.FirstTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MappingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MatchFamilyTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MissingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.NullableTypeStrategy;
import org.apache.flink.table.types.inference.strategies.UseArgumentTypeStrategy;
import org.apache.flink.table.types.inference.strategies.VaryingStringTypeStrategy;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class TypeStrategies {
    public static final TypeStrategy MISSING = new MissingTypeStrategy();
    public static final TypeStrategy COMMON = new CommonTypeStrategy();
    public static final TypeStrategy ROW = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, argumentDataTypes.size()).mapToObj(idx -> DataTypes.FIELD("f" + idx, (DataType)argumentDataTypes.get(idx))).toArray(DataTypes.Field[]::new);
        return Optional.of(DataTypes.ROW(fields).notNull());
    };
    public static final TypeStrategy MAP = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() < 2) {
            return Optional.empty();
        }
        return Optional.of(DataTypes.MAP(argumentDataTypes.get(0), argumentDataTypes.get(1)).notNull());
    };
    public static final TypeStrategy ARRAY = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() < 1) {
            return Optional.empty();
        }
        return Optional.of(DataTypes.ARRAY(argumentDataTypes.get(0)).notNull());
    };
    public static final TypeStrategy DECIMAL_PLUS = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType addend1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType addend2 = argumentDataTypes.get(1).getLogicalType();
        if (addend1 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (addend2 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!TypeStrategies.isDecimalComputation(addend1, addend2)) {
            return Optional.empty();
        }
        DecimalType decimalType = LogicalTypeMerging.findAdditionDecimalType(LogicalTypeChecks.getPrecision(addend1), LogicalTypeChecks.getScale(addend1), LogicalTypeChecks.getPrecision(addend2), LogicalTypeChecks.getScale(addend2));
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    };
    public static final TypeStrategy DECIMAL_DIVIDE = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType dividend = argumentDataTypes.get(0).getLogicalType();
        LogicalType divisor = argumentDataTypes.get(1).getLogicalType();
        if (dividend instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (divisor instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!TypeStrategies.isDecimalComputation(dividend, divisor)) {
            return Optional.empty();
        }
        DecimalType decimalType = LogicalTypeMerging.findDivisionDecimalType(LogicalTypeChecks.getPrecision(dividend), LogicalTypeChecks.getScale(dividend), LogicalTypeChecks.getPrecision(divisor), LogicalTypeChecks.getScale(divisor));
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    };
    public static final TypeStrategy DECIMAL_TIMES = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType factor1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType factor2 = argumentDataTypes.get(1).getLogicalType();
        if (factor1 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (factor2 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!TypeStrategies.isDecimalComputation(factor1, factor2)) {
            return Optional.empty();
        }
        DecimalType decimalType = LogicalTypeMerging.findMultiplicationDecimalType(LogicalTypeChecks.getPrecision(factor1), LogicalTypeChecks.getScale(factor1), LogicalTypeChecks.getPrecision(factor2), LogicalTypeChecks.getScale(factor2));
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    };
    public static final TypeStrategy DECIMAL_MOD = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType dividend = argumentDataTypes.get(0).getLogicalType();
        LogicalType divisor = argumentDataTypes.get(1).getLogicalType();
        if (dividend instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (divisor instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!TypeStrategies.isDecimalComputation(dividend, divisor)) {
            return Optional.empty();
        }
        int dividendScale = LogicalTypeChecks.getScale(dividend);
        int divisorScale = LogicalTypeChecks.getScale(divisor);
        if (dividendScale == 0 && divisorScale == 0) {
            return Optional.of(argumentDataTypes.get(1));
        }
        DecimalType decimalType = LogicalTypeMerging.findModuloDecimalType(LogicalTypeChecks.getPrecision(dividend), dividendScale, LogicalTypeChecks.getPrecision(divisor), divisorScale);
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    };
    public static final TypeStrategy DECIMAL_SCALE0 = callContext -> {
        DataType argumentDataType = callContext.getArgumentDataTypes().get(0);
        LogicalType argumentType = argumentDataType.getLogicalType();
        if (argumentType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataType);
        }
        if (LogicalTypeChecks.hasRoot(argumentType, LogicalTypeRoot.DECIMAL)) {
            if (LogicalTypeChecks.hasScale(argumentType, 0)) {
                return Optional.of(argumentDataType);
            }
            DecimalType inferredType = new DecimalType(argumentType.isNullable(), LogicalTypeChecks.getPrecision(argumentType), 0);
            return Optional.of(TypeConversions.fromLogicalToDataType(inferredType));
        }
        return Optional.empty();
    };
    public static final TypeStrategy ROUND = callContext -> {
        BigDecimal roundLength;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType argumentDataType = callContext.getArgumentDataTypes().get(0);
        LogicalType argumentType = argumentDataType.getLogicalType();
        if (argumentType instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataType);
        }
        if (!LogicalTypeChecks.hasRoot(argumentType, LogicalTypeRoot.DECIMAL)) {
            return Optional.of(argumentDataType);
        }
        if (argumentDataTypes.size() == 2) {
            if (!callContext.isArgumentLiteral(1) || callContext.isArgumentNull(1)) {
                return Optional.of(argumentDataType);
            }
            roundLength = callContext.getArgumentValue(1, BigDecimal.class).orElseThrow(AssertionError::new);
        } else {
            roundLength = BigDecimal.ZERO;
        }
        DecimalType inferredType = LogicalTypeMerging.findRoundDecimalType(LogicalTypeChecks.getPrecision(argumentType), LogicalTypeChecks.getScale(argumentType), roundLength.intValueExact());
        return Optional.of(TypeConversions.fromLogicalToDataType(inferredType));
    };
    public static final TypeStrategy STRING_CONCAT = callContext -> {
        LogicalType minimumType;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType type1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType type2 = argumentDataTypes.get(1).getLogicalType();
        int length = LogicalTypeChecks.getLength(type1) + LogicalTypeChecks.getLength(type2);
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        if (LogicalTypeChecks.hasFamily(type1, LogicalTypeFamily.CHARACTER_STRING) || LogicalTypeChecks.hasFamily(type2, LogicalTypeFamily.CHARACTER_STRING)) {
            minimumType = new CharType(false, length);
        } else if (LogicalTypeChecks.hasFamily(type1, LogicalTypeFamily.BINARY_STRING) || LogicalTypeChecks.hasFamily(type2, LogicalTypeFamily.BINARY_STRING)) {
            minimumType = new BinaryType(false, length);
        } else {
            return Optional.empty();
        }
        return LogicalTypeMerging.findCommonType(Arrays.asList(type1, type2, minimumType)).map(TypeConversions::fromLogicalToDataType);
    };
    public static final TypeStrategy GET = callContext -> {
        Optional<Integer> fieldIndex;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType rowDataType = argumentDataTypes.get(0);
        Optional<Object> result = Optional.empty();
        Optional<String> fieldName = callContext.getArgumentValue(1, String.class);
        if (fieldName.isPresent()) {
            result = DataTypeUtils.getField(rowDataType, fieldName.get());
        }
        if ((fieldIndex = callContext.getArgumentValue(1, Integer.class)).isPresent()) {
            result = DataTypeUtils.getField(rowDataType, fieldIndex.get());
        }
        return result.map(type -> {
            if (rowDataType.getLogicalType().isNullable()) {
                return (DataType)type.nullable();
            }
            return type;
        });
    };
    public static final TypeStrategy IF_NULL = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataType inputDataType = argumentDataTypes.get(0);
        DataType nullReplacementDataType = argumentDataTypes.get(1);
        if (!inputDataType.getLogicalType().isNullable()) {
            return Optional.of(inputDataType);
        }
        return Optional.of(nullReplacementDataType);
    };
    public static final TypeStrategy SOURCE_WATERMARK = callContext -> {
        DataType timestampDataType = callContext.getOutputDataType().filter(dt -> LogicalTypeChecks.hasFamily(dt.getLogicalType(), LogicalTypeFamily.TIMESTAMP)).orElse(DataTypes.TIMESTAMP_LTZ(3));
        return Optional.of(timestampDataType);
    };

    public static TypeStrategy explicit(DataType dataType) {
        return new ExplicitTypeStrategy(dataType);
    }

    public static TypeStrategy argument(int pos) {
        return new UseArgumentTypeStrategy(pos);
    }

    public static TypeStrategy first(TypeStrategy ... strategies) {
        return new FirstTypeStrategy(Arrays.asList(strategies));
    }

    public static TypeStrategy matchFamily(int argumentPos, LogicalTypeFamily family) {
        return new MatchFamilyTypeStrategy(argumentPos, family);
    }

    public static TypeStrategy mapping(Map<InputTypeStrategy, TypeStrategy> mappings) {
        return new MappingTypeStrategy(mappings);
    }

    public static TypeStrategy nullable(ConstantArgumentCount includedArgs, TypeStrategy initialStrategy) {
        return new NullableTypeStrategy(includedArgs, initialStrategy);
    }

    public static TypeStrategy nullable(TypeStrategy initialStrategy) {
        return TypeStrategies.nullable(ConstantArgumentCount.any(), initialStrategy);
    }

    public static TypeStrategy varyingString(TypeStrategy initialStrategy) {
        return new VaryingStringTypeStrategy(initialStrategy);
    }

    public static TypeStrategy aggArg0(Function<LogicalType, LogicalType> aggType, boolean nullableIfGroupingEmpty) {
        return callContext -> {
            DataType argDataType = callContext.getArgumentDataTypes().get(0);
            LogicalType argType = argDataType.getLogicalType();
            LogicalType result = (LogicalType)aggType.apply(argType);
            if (nullableIfGroupingEmpty && !callContext.isGroupedAggregation()) {
                result = result.copy(true);
            } else if (!nullableIfGroupingEmpty) {
                result = result.copy(false);
            }
            return Optional.of(TypeConversions.fromLogicalToDataType(result));
        };
    }

    private static boolean isDecimalComputation(LogicalType type1, LogicalType type2) {
        if (!LogicalTypeChecks.hasFamily(type1, LogicalTypeFamily.EXACT_NUMERIC) || !LogicalTypeChecks.hasFamily(type2, LogicalTypeFamily.EXACT_NUMERIC)) {
            return false;
        }
        return LogicalTypeChecks.hasRoot(type1, LogicalTypeRoot.DECIMAL) || LogicalTypeChecks.hasRoot(type2, LogicalTypeRoot.DECIMAL);
    }

    private TypeStrategies() {
    }
}

