/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.utils.EncodingUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EncodingUtilsTest {
    EncodingUtilsTest() {
    }

    @Test
    void testObjectStringEncoding() {
        MyPojo pojo = new MyPojo(33, "Hello");
        String base64 = EncodingUtils.encodeObjectToString((Serializable)pojo);
        Assertions.assertThat((Object)EncodingUtils.decodeStringToObject((String)base64, Serializable.class)).isEqualTo((Object)pojo);
    }

    @Test
    void testStringBase64Encoding() {
        String string = "Hello, this is apache flink.";
        String base64 = EncodingUtils.encodeStringToBase64((String)"Hello, this is apache flink.");
        Assertions.assertThat((String)base64).isEqualTo("SGVsbG8sIHRoaXMgaXMgYXBhY2hlIGZsaW5rLg==");
        Assertions.assertThat((String)EncodingUtils.decodeBase64ToString((String)base64)).isEqualTo("Hello, this is apache flink.");
    }

    @Test
    void testMd5Hex() {
        String string = "Hello, world! How are you? \u9ad8\u7cbe\u786e";
        Assertions.assertThat((String)EncodingUtils.hex((byte[])EncodingUtils.md5((String)"Hello, world! How are you? \u9ad8\u7cbe\u786e"))).isEqualTo("983abac84e994b4ba73be177e5cc298b");
    }

    @Test
    void testJavaEscaping() {
        Assertions.assertThat((String)EncodingUtils.escapeJava((String)"\\hello\"world'space/")).isEqualTo("\\\\hello\\\"world'space/");
    }

    @Test
    void testRepetition() {
        Assertions.assertThat((String)EncodingUtils.repeat((String)"we", (int)3)).isEqualTo("wewewe");
    }

    private static class MyPojo
    implements Serializable {
        private int number;
        private String string;

        public MyPojo(int number, String string) {
            this.number = number;
            this.string = string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.number == myPojo.number && Objects.equals(this.string, myPojo.string);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.string);
        }
    }
}

