/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.TestManagedCommittable;
import org.apache.flink.table.connector.sink.TestManagedSinkCommittableSerializer;
import org.apache.flink.table.connector.sink.TestManagedSinkCommitter;
import org.apache.flink.table.connector.sink.TestManagedSinkWriter;
import org.apache.flink.table.data.RowData;

public class TestManagedSink
implements Sink<RowData, TestManagedCommittable, Void, TestManagedCommittable> {
    private static final long serialVersionUID = 1L;
    private final ObjectIdentifier tableIdentifier;
    private final Path basePath;

    public TestManagedSink(ObjectIdentifier tableIdentifier, Path basePath) {
        this.tableIdentifier = tableIdentifier;
        this.basePath = basePath;
    }

    public SinkWriter<RowData, TestManagedCommittable, Void> createWriter(Sink.InitContext context, List<Void> states) throws IOException {
        return new TestManagedSinkWriter();
    }

    public Optional<Committer<TestManagedCommittable>> createCommitter() {
        return Optional.empty();
    }

    public Optional<SimpleVersionedSerializer<TestManagedCommittable>> getCommittableSerializer() {
        return Optional.of(new TestManagedSinkCommittableSerializer());
    }

    public Optional<SimpleVersionedSerializer<Void>> getWriterStateSerializer() {
        return Optional.empty();
    }

    public Optional<GlobalCommitter<TestManagedCommittable, TestManagedCommittable>> createGlobalCommitter() {
        return Optional.of(new TestManagedSinkCommitter(this.tableIdentifier, this.basePath));
    }

    public Optional<SimpleVersionedSerializer<TestManagedCommittable>> getGlobalCommittableSerializer() {
        return Optional.of(new TestManagedSinkCommittableSerializer());
    }

    public Collection<String> getCompatibleStateNames() {
        return Collections.emptyList();
    }
}

