/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.table.connector.source.TestManagedIterableSourceSplit;

public class TestManagedFileSourceSplitEnumerator
implements SplitEnumerator<TestManagedIterableSourceSplit, Void> {
    private final SplitEnumeratorContext<TestManagedIterableSourceSplit> context;
    private final Queue<TestManagedIterableSourceSplit> remainingSplits;

    public TestManagedFileSourceSplitEnumerator(SplitEnumeratorContext<TestManagedIterableSourceSplit> context, List<TestManagedIterableSourceSplit> splits) {
        this.context = context;
        this.remainingSplits = new ArrayDeque<TestManagedIterableSourceSplit>(splits);
    }

    public void start() {
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        TestManagedIterableSourceSplit split = this.remainingSplits.poll();
        if (split == null) {
            this.context.signalNoMoreSplits(subtaskId);
        } else {
            this.context.assignSplit((SourceSplit)split, subtaskId);
        }
    }

    public void addSplitsBack(List<TestManagedIterableSourceSplit> splits, int subtaskId) {
        splits.forEach(this.remainingSplits::offer);
    }

    public void addReader(int subtaskId) {
    }

    public Void snapshotState(long checkpointId) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }
}

