/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.test.InternalDataUtils;
import org.apache.flink.table.test.RowAssert;
import org.apache.flink.table.test.StringDataAssert;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.StringAssert;

@Experimental
public class RowDataAssert
extends AbstractAssert<RowDataAssert, RowData> {
    public RowDataAssert(RowData rowData) {
        super((Object)rowData, RowDataAssert.class);
    }

    public RowDataAssert hasKind(RowKind kind) {
        this.isNotNull();
        Assertions.assertThat((Comparable)((RowData)this.actual).getRowKind()).isEqualTo((Object)kind);
        return this;
    }

    public RowDataAssert hasArity(int arity) {
        this.isNotNull();
        Assertions.assertThat((int)((RowData)this.actual).getArity()).isEqualTo(arity);
        return this;
    }

    public StringDataAssert getStringData(int index) {
        this.isNotNullAt(index);
        return new StringDataAssert(((RowData)this.actual).getString(index));
    }

    public StringAssert getString(int index) {
        return this.getStringData(index).asString();
    }

    public LongAssert getLong(int index) {
        this.isNotNullAt(index);
        return new LongAssert(Long.valueOf(((RowData)this.actual).getLong(index)));
    }

    public RowDataAssert isNullAt(int index) {
        this.isNotNull();
        Assertions.assertThat((boolean)((RowData)this.actual).isNullAt(index)).isTrue();
        return this;
    }

    public RowDataAssert isNotNullAt(int index) {
        this.isNotNull();
        Assertions.assertThat((boolean)((RowData)this.actual).isNullAt(index)).isFalse();
        return this;
    }

    public RowDataAssert asGeneric(DataType dataType) {
        return this.asGeneric(dataType.getLogicalType());
    }

    public RowDataAssert asGeneric(LogicalType logicalType) {
        GenericRowData actual = InternalDataUtils.toGenericRow((RowData)this.actual, logicalType);
        return (RowDataAssert)new RowDataAssert((RowData)actual).usingComparator((x, y) -> {
            x = x == actual ? x : InternalDataUtils.toGenericRow(x, logicalType);
            Object object = y = y == actual ? y : InternalDataUtils.toGenericRow(y, logicalType);
            if (Objects.equals(x, y)) {
                return 0;
            }
            return Objects.hashCode(x) < Objects.hashCode(y) ? -1 : 1;
        });
    }

    public RowAssert asRow(DataType dataType) {
        return new RowAssert(InternalDataUtils.resolveToExternalOrNull(dataType).apply((RowData)this.actual));
    }
}

