/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;

@Internal
final class FunctionSignatureTemplate {
    final List<FunctionArgumentTemplate> argumentTemplates;
    final boolean isVarArgs;
    @Nullable
    final String[] argumentNames;
    final Boolean[] argumentOptionals;

    private FunctionSignatureTemplate(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, @Nullable String[] argumentNames, Boolean[] argumentOptionals) {
        this.argumentTemplates = argumentTemplates;
        this.isVarArgs = isVarArgs;
        this.argumentNames = argumentNames;
        this.argumentOptionals = argumentOptionals;
    }

    static FunctionSignatureTemplate of(List<FunctionArgumentTemplate> argumentTemplates, boolean isVarArgs, @Nullable String[] argumentNames, Boolean[] argumentOptionals) {
        if (argumentNames != null && argumentNames.length != argumentTemplates.size()) {
            throw ExtractionUtils.extractionError("Mismatch between number of argument names '%s' and argument types '%s'.", argumentNames.length, argumentTemplates.size());
        }
        if (argumentNames != null && (long)argumentNames.length != Arrays.stream(argumentNames).distinct().count()) {
            throw ExtractionUtils.extractionError("Argument name conflict, there are at least two argument names that are the same.", new Object[0]);
        }
        if (argumentOptionals != null && argumentOptionals.length != argumentTemplates.size()) {
            throw ExtractionUtils.extractionError("Mismatch between number of argument optionals '%s' and argument types '%s'.", argumentOptionals.length, argumentTemplates.size());
        }
        if (argumentOptionals != null) {
            for (int i = 0; i < argumentTemplates.size(); ++i) {
                DataType dataType = argumentTemplates.get((int)i).dataType;
                if (dataType == null || dataType.getLogicalType().isNullable() || !argumentOptionals[i].booleanValue()) continue;
                throw ExtractionUtils.extractionError("Argument at position %s is optional but its type doesn't accept null value.", i);
            }
        }
        return new FunctionSignatureTemplate(argumentTemplates, isVarArgs, argumentNames, argumentOptionals);
    }

    InputTypeStrategy toInputTypeStrategy() {
        ArgumentTypeStrategy[] argumentStrategies = (ArgumentTypeStrategy[])this.argumentTemplates.stream().map(FunctionArgumentTemplate::toArgumentTypeStrategy).toArray(ArgumentTypeStrategy[]::new);
        InputTypeStrategy strategy = this.isVarArgs ? (this.argumentNames == null ? InputTypeStrategies.varyingSequence(argumentStrategies) : InputTypeStrategies.varyingSequence(this.argumentNames, argumentStrategies)) : (this.argumentNames == null ? InputTypeStrategies.sequence(argumentStrategies) : InputTypeStrategies.sequence(this.argumentNames, argumentStrategies));
        return strategy;
    }

    List<Class<?>> toClass() {
        return IntStream.range(0, this.argumentTemplates.size()).mapToObj(i -> {
            Class<?> clazz = this.argumentTemplates.get(i).toConversionClass();
            if (i == this.argumentTemplates.size() - 1 && this.isVarArgs) {
                return Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionSignatureTemplate that = (FunctionSignatureTemplate)o;
        return this.isVarArgs == that.isVarArgs && this.argumentTemplates.equals(that.argumentTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.argumentTemplates, this.isVarArgs);
    }
}

