/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.ArrayList;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public final class ColumnStats {
    private final Long ndv;
    private final Long nullCount;
    private final Double avgLen;
    private final Integer maxLen;
    private final Number max;
    private final Number min;

    public ColumnStats(Long ndv, Long nullCount, Double avgLen, Integer maxLen, Number max, Number min) {
        this.ndv = ndv;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
        this.max = max;
        this.min = min;
    }

    public Long getNdv() {
        return this.ndv;
    }

    public Long getNullCount() {
        return this.nullCount;
    }

    public Double getAvgLen() {
        return this.avgLen;
    }

    public Integer getMaxLen() {
        return this.maxLen;
    }

    public Number getMaxValue() {
        return this.max;
    }

    public Number getMinValue() {
        return this.min;
    }

    public String toString() {
        ArrayList<String> columnStats = new ArrayList<String>();
        if (this.ndv != null) {
            columnStats.add("ndv=" + this.ndv);
        }
        if (this.nullCount != null) {
            columnStats.add("nullCount=" + this.nullCount);
        }
        if (this.avgLen != null) {
            columnStats.add("avgLen=" + this.avgLen);
        }
        if (this.maxLen != null) {
            columnStats.add("maxLen=" + this.maxLen);
        }
        if (this.max != null) {
            columnStats.add("max=" + this.max);
        }
        if (this.min != null) {
            columnStats.add("min=" + this.min);
        }
        String columnStatsStr = String.join((CharSequence)", ", columnStats);
        return "ColumnStats(" + columnStatsStr + ")";
    }

    public ColumnStats copy() {
        return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
    }
}

