/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.plan.stats.ColumnStats;

@PublicEvolving
public final class TableStats {
    public static final TableStats UNKNOWN = new TableStats(-1L, new HashMap<String, ColumnStats>());
    private final long rowCount;
    private final Map<String, ColumnStats> colStats;

    public TableStats(long rowCount) {
        this(rowCount, new HashMap<String, ColumnStats>());
    }

    public TableStats(long rowCount, Map<String, ColumnStats> colStats) {
        this.rowCount = rowCount;
        this.colStats = colStats;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public Map<String, ColumnStats> getColumnStats() {
        return this.colStats;
    }

    public TableStats copy() {
        TableStats copy = new TableStats(this.rowCount);
        for (Map.Entry<String, ColumnStats> entry : this.colStats.entrySet()) {
            copy.colStats.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }
}

