/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeValidator;
import org.apache.flink.table.types.inference.InputTypeValidators;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TypeInference {
    private final InputTypeValidator inputTypeValidator;
    @Nullable
    private final TypeStrategy accumulatorTypeStrategy;
    private final TypeStrategy outputTypeStrategy;
    @Nullable
    private final List<String> argumentNames;
    @Nullable
    private final List<DataType> argumentTypes;

    private TypeInference(InputTypeValidator inputTypeValidator, @Nullable TypeStrategy accumulatorTypeStrategy, TypeStrategy outputTypeStrategy, @Nullable List<String> argumentNames, @Nullable List<DataType> argumentTypes) {
        this.inputTypeValidator = inputTypeValidator;
        this.accumulatorTypeStrategy = accumulatorTypeStrategy;
        this.outputTypeStrategy = outputTypeStrategy;
        if (argumentNames != null && argumentTypes != null && argumentNames.size() != argumentTypes.size()) {
            throw new IllegalArgumentException(String.format("Mismatch between argument types %d and argument names %d.", argumentNames.size(), argumentTypes.size()));
        }
        this.argumentNames = argumentNames;
        this.argumentTypes = argumentTypes;
    }

    public InputTypeValidator getInputTypeValidator() {
        return this.inputTypeValidator;
    }

    public Optional<TypeStrategy> getAccumulatorTypeStrategy() {
        return Optional.ofNullable(this.accumulatorTypeStrategy);
    }

    public TypeStrategy getOutputTypeStrategy() {
        return this.outputTypeStrategy;
    }

    public Optional<List<String>> getArgumentNames() {
        return Optional.ofNullable(this.argumentNames);
    }

    public Optional<List<DataType>> getArgumentTypes() {
        return Optional.ofNullable(this.argumentTypes);
    }

    public static class Builder {
        private InputTypeValidator inputTypeValidator = InputTypeValidators.PASSING;
        @Nullable
        private TypeStrategy accumulatorTypeStrategy;
        @Nullable
        private TypeStrategy outputTypeStrategy;
        @Nullable
        private List<String> argumentNames;
        @Nullable
        private List<DataType> argumentTypes;

        public Builder inputTypeValidator(InputTypeValidator inputTypeValidator) {
            this.inputTypeValidator = (InputTypeValidator)Preconditions.checkNotNull((Object)inputTypeValidator, (String)"Input type validator must not be null.");
            return this;
        }

        public Builder accumulatorTypeStrategy(TypeStrategy accumulatorTypeStrategy) {
            this.accumulatorTypeStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)accumulatorTypeStrategy, (String)"Accumulator type strategy must not be null.");
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.outputTypeStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)outputTypeStrategy, (String)"Output type strategy must not be null.");
            return this;
        }

        public Builder namedArguments(List<String> argumentNames) {
            this.argumentNames = (List)Preconditions.checkNotNull(argumentNames, (String)"List of argument names must not be null.");
            return this;
        }

        public Builder typedArguments(List<DataType> argumentTypes) {
            this.argumentTypes = (List)Preconditions.checkNotNull(argumentTypes, (String)"List of argument types must not be null.");
            return this;
        }

        public TypeInference build() {
            return new TypeInference(this.inputTypeValidator, this.accumulatorTypeStrategy, (TypeStrategy)Preconditions.checkNotNull((Object)this.outputTypeStrategy, (String)"Output type strategy must not be null."), this.argumentNames, this.argumentTypes);
        }
    }
}

