/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;

@Internal
public class LogicalTypeDuplicator
extends LogicalTypeDefaultVisitor<LogicalType> {
    @Override
    public LogicalType visit(ArrayType arrayType) {
        return new ArrayType(arrayType.isNullable(), arrayType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(MultisetType multisetType) {
        return new MultisetType(multisetType.isNullable(), multisetType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(MapType mapType) {
        return new MapType(mapType.isNullable(), mapType.getKeyType().accept(this), mapType.getValueType().accept(this));
    }

    @Override
    public LogicalType visit(RowType rowType) {
        List<RowType.RowField> fields = rowType.getFields().stream().map(f -> {
            if (f.getDescription().isPresent()) {
                return new RowType.RowField(f.getName(), f.getType().accept(this), f.getDescription().get());
            }
            return new RowType.RowField(f.getName(), f.getType().accept(this));
        }).collect(Collectors.toList());
        return new RowType(rowType.isNullable(), fields);
    }

    @Override
    public LogicalType visit(DistinctType distinctType) {
        DistinctType.Builder builder = new DistinctType.Builder(distinctType.getObjectIdentifier(), distinctType.getSourceType().accept(this));
        distinctType.getDescription().ifPresent(builder::setDescription);
        return builder.build();
    }

    @Override
    public LogicalType visit(StructuredType structuredType) {
        List<StructuredType.StructuredAttribute> attributes = structuredType.getAttributes().stream().map(a -> {
            if (a.getDescription().isPresent()) {
                return new StructuredType.StructuredAttribute(a.getName(), a.getType().accept(this), a.getDescription().get());
            }
            return new StructuredType.StructuredAttribute(a.getName(), a.getType().accept(this));
        }).collect(Collectors.toList());
        StructuredType.Builder builder = new StructuredType.Builder(structuredType.getObjectIdentifier(), attributes);
        builder.setNullable(structuredType.isNullable());
        builder.setFinal(structuredType.isFinal());
        builder.setInstantiable(structuredType.isInstantiable());
        builder.setComparision(structuredType.getComparision());
        structuredType.getSuperType().ifPresent(st -> {
            LogicalType visited = st.accept(this);
            if (!(visited instanceof StructuredType)) {
                throw new TableException("Unexpected super type. Structured type expected but was: " + visited);
            }
            builder.setSuperType((StructuredType)visited);
        });
        structuredType.getDescription().ifPresent(builder::setDescription);
        structuredType.getImplementationClass().ifPresent(builder::setImplementationClass);
        return builder.build();
    }

    @Override
    protected LogicalType defaultMethod(LogicalType logicalType) {
        return logicalType.copy();
    }
}

