/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public abstract class EncodingUtils {
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64_DECODER = Base64.getUrlDecoder();
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;

    private EncodingUtils() {
    }

    public static String escapeBackticks(String s) {
        return s.replace("`", "``");
    }

    public static String escapeSingleQuotes(String s) {
        return s.replace("'", "''");
    }

    public static String escapeIdentifier(String s) {
        return "`" + EncodingUtils.escapeBackticks(s) + "`";
    }

    public static String encodeObjectToString(Serializable obj) {
        try {
            byte[] bytes = InstantiationUtil.serializeObject((Object)obj);
            return new String(BASE64_ENCODER.encode(bytes), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ValidationException("Unable to serialize object '" + obj.toString() + "' of class '" + obj.getClass().getName() + "'.");
        }
    }

    public static <T extends Serializable> T decodeStringToObject(String base64String, Class<T> baseClass) {
        return EncodingUtils.decodeStringToObject(base64String, baseClass, Thread.currentThread().getContextClassLoader());
    }

    public static <T extends Serializable> T decodeStringToObject(String base64String, Class<T> baseClass, ClassLoader classLoader) {
        try {
            byte[] bytes = BASE64_DECODER.decode(base64String.getBytes(StandardCharsets.UTF_8));
            Serializable instance = (Serializable)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)classLoader);
            if (instance != null && !baseClass.isAssignableFrom(instance.getClass())) {
                throw new ValidationException("Object '" + instance + "' does not match expected base class '" + baseClass + "' but is of class '" + instance.getClass() + "'.");
            }
            return (T)instance;
        }
        catch (Exception e) {
            throw new ValidationException("Unable to deserialize string '" + base64String + "' of base class '" + baseClass.getName() + "'.", e);
        }
    }

    public static Class<?> loadClass(String qualifiedName, ClassLoader classLoader) {
        try {
            return Class.forName(qualifiedName, true, classLoader);
        }
        catch (Exception e) {
            throw new ValidationException("Class '" + qualifiedName + "' could not be loaded. Please note that inner classes must be globally accessible and declared static.", e);
        }
    }

    public static Class<?> loadClass(String qualifiedName) {
        return EncodingUtils.loadClass(qualifiedName, Thread.currentThread().getContextClassLoader());
    }

    public static String encodeBytesToBase64(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static byte[] decodeBase64ToBytes(String base64) {
        return Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeStringToBase64(String string) {
        return EncodingUtils.encodeBytesToBase64(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64ToString(String base64) {
        return new String(EncodingUtils.decodeBase64ToBytes(base64), StandardCharsets.UTF_8);
    }

    public static byte[] md5(String string) {
        try {
            return MessageDigest.getInstance("MD5").digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TableException("Unsupported MD5 algorithm.", e);
        }
    }

    public static String hex(String string) {
        return EncodingUtils.hex(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String objectToString(Object object) {
        String arrayString = Arrays.deepToString(new Object[]{object});
        return arrayString.substring(1, arrayString.length() - 1);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return EncodingUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return EncodingUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String escapeJava(String str) {
        return EncodingUtils.escapeJavaStyleString(str, false);
    }

    private static String escapeJavaStyleString(String str, boolean escapeSingleQuotes) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            EncodingUtils.escapeJavaStyleString(writer, str, escapeSingleQuotes);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + EncodingUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + EncodingUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + EncodingUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + EncodingUtils.hex(ch));
                            break;
                        }
                        out.write("\\u000" + EncodingUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block12;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block12;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block12;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }
}

