/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.base.Predicate;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class ProjectTableScanRule
extends RelRule<Config> {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = ProjectTableScanRule::test;

    protected ProjectTableScanRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withDescription(description).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    protected static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(ProjectableFilterableTable.class) != null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length == 2) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, project, scan);
        } else if (call.rels.length == 3) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, project, scan);
        } else {
            throw new AssertionError();
        }
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        List<Integer> projectsPushDown;
        ImmutableList<RexNode> filtersPushDown;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        final ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (!selectedColumns.contains(inputRef.getIndex())) {
                    selectedColumns.add(inputRef.getIndex());
                }
                return null;
            }
        };
        visitor.visitEach(project.getProjects());
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filtersPushDown = bindableScan.filters;
            projectsPushDown = selectedColumns.stream().map(bindableScan.projects::get).collect(Collectors.toList());
        } else {
            filtersPushDown = ImmutableList.of();
            projectsPushDown = selectedColumns;
        }
        Bindables.BindableTableScan newScan = Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filtersPushDown, projectsPushDown);
        Mapping mapping = Mappings.target(selectedColumns, scan.getRowType().getFieldCount());
        List<RexNode> newProjectRexNodes = RexUtil.apply((Mappings.TargetMapping)mapping, project.getProjects());
        if (RexUtil.isIdentity(newProjectRexNodes, newScan.getRowType())) {
            call.transformTo(newScan);
        } else {
            call.transformTo(call.builder().push(newScan).project(newProjectRexNodes).build());
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(Project.class).oneInput(b1 -> b1.operand(TableScan.class).predicate(ProjectTableScanRule::test).noInputs())).as(Config.class);
        public static final Config INTERPRETER = DEFAULT.withOperandSupplier(b0 -> b0.operand(Project.class).oneInput(b1 -> b1.operand(EnumerableInterpreter.class).oneInput(b2 -> b2.operand(TableScan.class).predicate(ProjectTableScanRule::test).noInputs()))).withDescription("ProjectTableScanRule:interpreter").as(Config.class);

        @Override
        default public ProjectTableScanRule toRule() {
            return new ProjectTableScanRule(this);
        }
    }
}

