/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.io.Serializable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.plan.schema.GenericRelDataType;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class FlinkTypeFactory$ {
    public static FlinkTypeFactory$ MODULE$;
    private final FlinkTypeFactory INSTANCE;

    static {
        new FlinkTypeFactory$();
    }

    public FlinkTypeFactory INSTANCE() {
        return this.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIndicatorType(LogicalType t) {
        LogicalType logicalType = t;
        if (!(logicalType instanceof TimestampType)) return false;
        TimestampType timestampType = (TimestampType)logicalType;
        TimestampKind timestampKind = timestampType.getKind();
        TimestampKind timestampKind2 = TimestampKind.ROWTIME;
        if (timestampKind == null) {
            if (timestampKind2 == null) return true;
        } else if (timestampKind.equals(timestampKind2)) return true;
        TimestampKind timestampKind3 = timestampType.getKind();
        TimestampKind timestampKind4 = TimestampKind.PROCTIME;
        if (timestampKind3 != null) {
            if (!timestampKind3.equals(timestampKind4)) return false;
            return true;
        }
        if (timestampKind4 == null) return true;
        return false;
    }

    public boolean isTimeIndicatorType(RelDataType relDataType) {
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType;
        return bl;
    }

    public boolean isRowtimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && (timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    public boolean isProctimeIndicatorType(RelDataType relDataType) {
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType2 = relDataType;
        boolean bl = relDataType2 instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType2).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isProctimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && !(timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isRowtimeIndicatorType(TypeInformation<?> typeInfo) {
        TimeIndicatorTypeInfo timeIndicatorTypeInfo;
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo && (timeIndicatorTypeInfo = (TimeIndicatorTypeInfo)typeInformation).isEventTime();
        return bl;
    }

    @Deprecated
    public boolean isTimeIndicatorType(TypeInformation<?> typeInfo) {
        TypeInformation<?> typeInformation = typeInfo;
        boolean bl = typeInformation instanceof TimeIndicatorTypeInfo;
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public LogicalType toLogicalType(RelDataType relDataType) {
        block37: {
            block48: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block36: {
                                                            var4_2 = false;
                                                            var5_3 = null;
                                                            var6_4 = relDataType.getSqlTypeName();
                                                            if (!SqlTypeName.BOOLEAN.equals((Object)var6_4)) break block36;
                                                            var2_5 = new BooleanType();
                                                            break block37;
                                                        }
                                                        if (!SqlTypeName.TINYINT.equals((Object)var6_4)) break block38;
                                                        var2_5 = new TinyIntType();
                                                        break block37;
                                                    }
                                                    if (!SqlTypeName.SMALLINT.equals((Object)var6_4)) break block39;
                                                    var2_5 = new SmallIntType();
                                                    break block37;
                                                }
                                                if (!SqlTypeName.INTEGER.equals((Object)var6_4)) break block40;
                                                var2_5 = new IntType();
                                                break block37;
                                            }
                                            if (!SqlTypeName.BIGINT.equals((Object)var6_4)) break block41;
                                            var2_5 = new BigIntType();
                                            break block37;
                                        }
                                        if (!SqlTypeName.FLOAT.equals((Object)var6_4)) break block42;
                                        var2_5 = new FloatType();
                                        break block37;
                                    }
                                    if (!SqlTypeName.DOUBLE.equals((Object)var6_4)) break block43;
                                    var2_5 = new DoubleType();
                                    break block37;
                                }
                                if (!SqlTypeName.CHAR.equals((Object)var6_4)) break block44;
                                var2_5 = relDataType.getPrecision() == 0 ? CharType.ofEmptyLiteral() : new CharType(relDataType.getPrecision());
                                break block37;
                            }
                            if (!SqlTypeName.VARCHAR.equals((Object)var6_4)) break block45;
                            var2_5 = relDataType.getPrecision() == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(relDataType.getPrecision());
                            break block37;
                        }
                        if (!SqlTypeName.BINARY.equals((Object)var6_4)) break block46;
                        var2_5 = relDataType.getPrecision() == 0 ? BinaryType.ofEmptyLiteral() : new BinaryType(relDataType.getPrecision());
                        break block37;
                    }
                    if (!SqlTypeName.VARBINARY.equals((Object)var6_4)) break block47;
                    var2_5 = relDataType.getPrecision() == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(relDataType.getPrecision());
                    break block37;
                }
                if (!SqlTypeName.DECIMAL.equals((Object)var6_4)) break block48;
                var2_5 = new DecimalType(relDataType.getPrecision(), relDataType.getScale());
                break block37;
            }
            if (!SqlTypeName.TIMESTAMP.equals((Object)var6_4)) ** GOTO lbl-1000
            var4_2 = true;
            var5_3 = var6_4;
            if (relDataType instanceof TimeIndicatorRelDataType) {
                indicator = (TimeIndicatorRelDataType)relDataType;
                var2_5 = indicator.isEventTime() != false ? new TimestampType(true, TimestampKind.ROWTIME, 3) : new TimestampType(true, TimestampKind.PROCTIME, 3);
            } else if (SqlTypeName.DATE.equals((Object)var6_4)) {
                var2_5 = new DateType();
            } else if (SqlTypeName.TIME.equals((Object)var6_4)) {
                if (relDataType.getPrecision() > 3) {
                    throw new TableException(new StringBuilder(33).append("TIME precision is not supported: ").append(relDataType.getPrecision()).toString());
                }
                var2_5 = new TimeType();
            } else if (var4_2) {
                var2_5 = new TimestampType(relDataType.getPrecision());
            } else if (SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)var6_4)) {
                var2_5 = new LocalZonedTimestampType(relDataType.getPrecision());
            } else if (SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)var6_4)) {
                var2_5 = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).getLogicalType();
            } else if (SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)var6_4)) {
                if (relDataType.getPrecision() > 3) {
                    throw new TableException(new StringBuilder(47).append("DAY_INTERVAL_TYPES precision is not supported: ").append(relDataType.getPrecision()).toString());
                }
                var2_5 = DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3)).getLogicalType();
            } else if (SqlTypeName.NULL.equals((Object)var6_4)) {
                var2_5 = new NullType();
            } else if (SqlTypeName.SYMBOL.equals((Object)var6_4)) {
                var2_5 = new TypeInformationRawType(TypeExtractor.createTypeInfo(Enum.class));
            } else if (SqlTypeName.ANY.equals((Object)var6_4) && relDataType instanceof GenericRelDataType) {
                genericRelDataType = (GenericRelDataType)relDataType;
                var2_5 = genericRelDataType.genericType();
            } else if (SqlTypeName.ROW.equals((Object)var6_4) && relDataType instanceof RelRecordType) {
                var2_5 = this.toLogicalRowType(relDataType);
            } else if (SqlTypeName.STRUCTURED.equals((Object)var6_4) && relDataType instanceof StructuredRelDataType) {
                var2_5 = ((StructuredRelDataType)relDataType).getStructuredType();
            } else if (SqlTypeName.MULTISET.equals((Object)var6_4)) {
                var2_5 = new MultisetType(this.toLogicalType(relDataType.getComponentType()));
            } else if (SqlTypeName.ARRAY.equals((Object)var6_4)) {
                var2_5 = new ArrayType(this.toLogicalType(relDataType.getComponentType()));
            } else if (SqlTypeName.MAP.equals((Object)var6_4) && relDataType instanceof MapSqlType) {
                mapRelDataType = (MapSqlType)relDataType;
                var2_5 = new MapType(this.toLogicalType(mapRelDataType.getKeyType()), this.toLogicalType(mapRelDataType.getValueType()));
            } else if (SqlTypeName.CURSOR.equals((Object)var6_4)) {
                var2_5 = new TypeInformationRawType((TypeInformation)new NothingTypeInfo());
            } else if (SqlTypeName.OTHER.equals((Object)var6_4) && relDataType instanceof RawRelDataType) {
                var2_5 = ((RawRelDataType)relDataType).getRawType();
            } else {
                throw new TableException(new StringBuilder(23).append("Type is not supported: ").append((Object)var6_4).toString());
            }
        }
        logicalType = var2_5;
        return logicalType.copy(relDataType.isNullable());
    }

    public TableSchema toTableSchema(RelDataType relDataType) {
        String[] fieldNames = (String[])relDataType.getFieldNames().toArray((Object[])new String[0]);
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relDataType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)MODULE$.toLogicalType(field.getType())), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(fieldNames, fieldTypes).build();
    }

    public RowType toLogicalRowType(RelDataType relType) {
        Preconditions.checkArgument((boolean)relType.isStruct());
        return RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldType -> MODULE$.toLogicalType(fieldType.getType()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(relType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    private FlinkTypeFactory$() {
        MODULE$ = this;
        this.INSTANCE = new FlinkTypeFactory(new FlinkTypeSystem());
    }
}

